/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.BadCombiner;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class ServerSideErrorTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    @Override
    public void run() throws Exception {
        this.getConnector().tableOperations().create("tt");
        IteratorSetting is = new IteratorSetting(5, "Bad Aggregator", BadCombiner.class);
        Combiner.setColumns((IteratorSetting)is, Collections.singletonList(new IteratorSetting.Column("acf")));
        this.getConnector().tableOperations().attachIterator("tt", is);
        BatchWriter bw = this.getConnector().createBatchWriter("tt", new BatchWriterConfig());
        Mutation m = new Mutation(new Text("r1"));
        m.put(new Text("acf"), new Text("foo"), new Value(new byte[]{49}));
        bw.addMutation(m);
        bw.close();
        Scanner scanner = this.getConnector().createScanner("tt", Constants.NO_AUTHS);
        boolean caught = false;
        try {
            for (Map.Entry entry : scanner) {
                entry.getKey();
            }
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            throw new Exception("Scan did not fail");
        }
        BatchScanner bs = this.getConnector().createBatchScanner("tt", Constants.NO_AUTHS, 2);
        bs.setRanges(Collections.singleton(new Range()));
        caught = false;
        try {
            for (Map.Entry entry : bs) {
                entry.getKey();
            }
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            throw new Exception("batch scan did not fail");
        }
        TableOperations to = this.getConnector().tableOperations();
        for (Map.Entry e : to.getProperties("tt")) {
            to.removeProperty("tt", (String)e.getKey());
        }
        UtilWaitThread.sleep((long)500L);
        scanner = this.getConnector().createScanner("tt", Constants.NO_AUTHS);
        for (Map.Entry entry : scanner) {
            entry.getKey();
        }
        scanner.addScanIterator(new IteratorSetting(100, "bogus", "com.bogus.iterator"));
        caught = false;
        try {
            for (Map.Entry entry : scanner) {
                entry.getKey();
            }
        }
        catch (Exception e) {
            caught = true;
        }
        if (!caught) {
            throw new Exception("Scan did not fail");
        }
    }
}

