/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class ScanSessionTimeOutTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(Property.TSERV_SESSION_MAXIDLE.getKey(), "3");
        return config;
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.singletonList(new FunctionalTest.TableSetup("abc"));
    }

    @Override
    public void run() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("abc", new BatchWriterConfig());
        for (int i = 0; i < 100000; ++i) {
            Mutation m = new Mutation(new Text(String.format("%08d", i)));
            for (int j = 0; j < 3; ++j) {
                m.put(new Text("cf1"), new Text("cq" + j), new Value((i + "_" + j).getBytes(Constants.UTF8)));
            }
            bw.addMutation(m);
        }
        bw.close();
        Scanner scanner = this.getConnector().createScanner("abc", new Authorizations());
        scanner.setBatchSize(1000);
        Iterator iter = scanner.iterator();
        this.verify(iter, 0, 200);
        UtilWaitThread.sleep((long)9000L);
        this.verify(iter, 200, 100000);
    }

    private void verify(Iterator<Map.Entry<Key, Value>> iter, int start, int stop) throws Exception {
        for (int i = start; i < stop; ++i) {
            Text er = new Text(String.format("%08d", i));
            for (int j = 0; j < 3; ++j) {
                Map.Entry<Key, Value> entry = iter.next();
                if (!entry.getKey().getRow().equals((Object)er)) {
                    throw new Exception("row " + entry.getKey().getRow() + " != " + er);
                }
                if (!entry.getKey().getColumnFamily().equals((Object)new Text("cf1"))) {
                    throw new Exception("cf " + entry.getKey().getColumnFamily() + " != cf1");
                }
                if (!entry.getKey().getColumnQualifier().equals((Object)new Text("cq" + j))) {
                    throw new Exception("cq " + entry.getKey().getColumnQualifier() + " != cq" + j);
                }
                if (entry.getValue().toString().equals("" + i + "_" + j)) continue;
                throw new Exception("value " + entry.getValue() + " != " + i + "_" + j);
            }
        }
    }
}

