/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class ScanRangeTest
extends FunctionalTest {
    private static final int TS_LIMIT = 1;
    private static final int CQ_LIMIT = 5;
    private static final int CF_LIMIT = 5;
    private static final int ROW_LIMIT = 100;

    @Override
    public void cleanup() {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        ArrayList<FunctionalTest.TableSetup> ts = new ArrayList<FunctionalTest.TableSetup>();
        ts.add(new FunctionalTest.TableSetup("table1"));
        TreeSet<Text> splitRows = new TreeSet<Text>();
        int splits = 3;
        for (int i = 100 / splits; i < 100; i += 100 / splits) {
            splitRows.add(ScanRangeTest.createRow(i));
        }
        Map<String, String> empty = Collections.emptyMap();
        ts.add(new FunctionalTest.TableSetup("table2", empty, splitRows));
        return ts;
    }

    @Override
    public void run() throws Exception {
        this.insertData("table1");
        this.scanTable("table1");
        this.insertData("table2");
        this.scanTable("table2");
    }

    private void scanTable(String table) throws Exception {
        int i;
        this.scanRange(table, new IntKey(0, 0, 0, 0L), new IntKey(1, 0, 0, 0L));
        this.scanRange(table, new IntKey(0, 0, 0, 0L), new IntKey(99, 4, 4, 0L));
        this.scanRange(table, null, null);
        for (i = 0; i < 100; i += 33) {
            for (int j = 0; j < 5; j += 2) {
                for (int k = 1; k < 5; k += 2) {
                    this.scanRange(table, null, new IntKey(i, j, k, 0L));
                    this.scanRange(table, new IntKey(0, 0, 0, 0L), new IntKey(i, j, k, 0L));
                    this.scanRange(table, new IntKey(i, j, k, 0L), new IntKey(99, 4, 4, 0L));
                    this.scanRange(table, new IntKey(i, j, k, 0L), null);
                }
            }
        }
        for (i = 0; i < 100; ++i) {
            this.scanRange(table, new IntKey(i, 0, 0, 0L), new IntKey(i, 4, 4, 0L));
            if (i <= 0 || i >= 99) continue;
            this.scanRange(table, new IntKey(i - 1, 0, 0, 0L), new IntKey(i + 1, 4, 4, 0L));
        }
    }

    private void scanRange(String table, IntKey ik1, IntKey ik2) throws Exception {
        this.scanRange(table, ik1, false, ik2, false);
        this.scanRange(table, ik1, false, ik2, true);
        this.scanRange(table, ik1, true, ik2, false);
        this.scanRange(table, ik1, true, ik2, true);
    }

    private void scanRange(String table, IntKey ik1, boolean inclusive1, IntKey ik2, boolean inclusive2) throws Exception {
        IntKey expectedEndIntKey;
        IntKey expectedIntKey;
        Scanner scanner = this.getConnector().createScanner(table, Constants.NO_AUTHS);
        Key key1 = null;
        Key key2 = null;
        if (ik1 != null) {
            key1 = ik1.createKey();
            expectedIntKey = ik1;
            if (!inclusive1) {
                expectedIntKey = expectedIntKey.increment();
            }
        } else {
            expectedIntKey = new IntKey(0, 0, 0, 0L);
        }
        if (ik2 != null) {
            key2 = ik2.createKey();
            expectedEndIntKey = ik2;
            if (inclusive2) {
                expectedEndIntKey = expectedEndIntKey.increment();
            }
        } else {
            expectedEndIntKey = new IntKey(100, 0, 0, 0L);
        }
        Range range = new Range(key1, inclusive1, key2, inclusive2);
        scanner.setRange(range);
        for (Map.Entry entry : scanner) {
            Key expectedKey = expectedIntKey.createKey();
            if (!expectedKey.equals(entry.getKey())) {
                throw new Exception(" " + expectedKey + " != " + entry.getKey());
            }
            expectedIntKey = expectedIntKey.increment();
        }
        if (!expectedIntKey.createKey().equals((Object)expectedEndIntKey.createKey())) {
            throw new Exception(" " + expectedIntKey.createKey() + " != " + expectedEndIntKey.createKey());
        }
    }

    private static Text createCF(int cf) {
        Text tcf = new Text(String.format("cf_%03d", cf));
        return tcf;
    }

    private static Text createCQ(int cf) {
        Text tcf = new Text(String.format("cq_%03d", cf));
        return tcf;
    }

    private static Text createRow(int row) {
        Text trow = new Text(String.format("r_%06d", row));
        return trow;
    }

    private void insertData(String table) throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter(table, new BatchWriterConfig());
        for (int i = 0; i < 100; ++i) {
            Mutation m = new Mutation(ScanRangeTest.createRow(i));
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 5; ++k) {
                    for (int t = 0; t < 1; ++t) {
                        m.put(ScanRangeTest.createCF(j), ScanRangeTest.createCQ(k), (long)t, new Value(String.format("%06d_%03d_%03d_%03d", i, j, k, t).getBytes(Constants.UTF8)));
                    }
                }
            }
            bw.addMutation(m);
        }
        bw.close();
    }

    private static class IntKey {
        private int row;
        private int cf;
        private int cq;
        private long ts;

        IntKey(IntKey ik) {
            this.row = ik.row;
            this.cf = ik.cf;
            this.cq = ik.cq;
            this.ts = ik.ts;
        }

        IntKey(int row, int cf, int cq, long ts) {
            this.row = row;
            this.cf = cf;
            this.cq = cq;
            this.ts = ts;
        }

        Key createKey() {
            Text trow = ScanRangeTest.createRow(this.row);
            Text tcf = ScanRangeTest.createCF(this.cf);
            Text tcq = ScanRangeTest.createCQ(this.cq);
            return new Key(trow, tcf, tcq, this.ts);
        }

        IntKey increment() {
            IntKey ik = new IntKey(this);
            ++ik.ts;
            if (ik.ts >= 1L) {
                ik.ts = 0L;
                ++ik.cq;
                if (ik.cq >= 5) {
                    ik.cq = 0;
                    ++ik.cf;
                    if (ik.cf >= 5) {
                        ik.cf = 0;
                        ++ik.row;
                    }
                }
            }
            return ik;
        }
    }
}

