/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class ScanIteratorTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.singletonList(new FunctionalTest.TableSetup("foo"));
    }

    @Override
    public void run() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("foo", new BatchWriterConfig());
        for (int i = 0; i < 1000; ++i) {
            Mutation m = new Mutation(new Text(String.format("%06d", i)));
            m.put(new Text("cf1"), new Text("cq1"), new Value(Integer.toString(1000 - i).getBytes(Constants.UTF8)));
            m.put(new Text("cf1"), new Text("cq2"), new Value(Integer.toString(i - 1000).getBytes(Constants.UTF8)));
            bw.addMutation(m);
        }
        bw.close();
        Scanner scanner = this.getConnector().createScanner("foo", new Authorizations());
        this.setupIter((ScannerBase)scanner);
        this.verify((Iterable<Map.Entry<Key, Value>>)scanner, 1, 999);
        BatchScanner bscanner = this.getConnector().createBatchScanner("foo", new Authorizations(), 3);
        bscanner.setRanges(Collections.singleton(new Range((Key)null, null)));
        this.setupIter((ScannerBase)bscanner);
        this.verify((Iterable<Map.Entry<Key, Value>>)bscanner, 1, 999);
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(new Text(String.format("%06d", 1))));
        ranges.add(new Range(new Text(String.format("%06d", 6)), new Text(String.format("%06d", 16))));
        ranges.add(new Range(new Text(String.format("%06d", 20))));
        ranges.add(new Range(new Text(String.format("%06d", 23))));
        ranges.add(new Range(new Text(String.format("%06d", 56)), new Text(String.format("%06d", 61))));
        ranges.add(new Range(new Text(String.format("%06d", 501)), new Text(String.format("%06d", 504))));
        ranges.add(new Range(new Text(String.format("%06d", 998)), new Text(String.format("%06d", 1000))));
        HashSet<Integer> got = new HashSet<Integer>();
        HashSet<Integer> expected = new HashSet<Integer>();
        for (int i : new int[]{1, 7, 9, 11, 13, 15, 23, 57, 59, 61, 501, 503, 999}) {
            expected.add(i);
        }
        bscanner.setRanges(ranges);
        for (Map.Entry entry : bscanner) {
            got.add(Integer.parseInt(((Key)entry.getKey()).getRow().toString()));
        }
        System.out.println("got : " + got);
        if (!got.equals(expected)) {
            throw new Exception(got + " != " + expected);
        }
        bscanner.close();
    }

    private void verify(Iterable<Map.Entry<Key, Value>> scanner, int start, int finish) throws Exception {
        int expected = start;
        for (Map.Entry<Key, Value> entry : scanner) {
            if (Integer.parseInt(entry.getKey().getRow().toString()) != expected) {
                throw new Exception("Saw unexpexted " + entry.getKey().getRow() + " " + expected);
            }
            if (!entry.getKey().getColumnQualifier().toString().equals("cq2")) continue;
            expected += 2;
        }
        if (expected != finish + 2) {
            throw new Exception("Ended at " + expected + " not " + (finish + 2));
        }
    }

    private void setupIter(ScannerBase scanner) throws Exception {
        IteratorSetting dropMod = new IteratorSetting(50, "dropMod", "org.apache.accumulo.test.functional.DropModIter");
        dropMod.addOption("mod", "2");
        dropMod.addOption("drop", "0");
        scanner.addScanIterator(dropMod);
    }
}

