/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.Help;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class RunTests
extends Configured
implements Tool {
    public static final String JOB_NAME = "Functional Test Runner";
    private static final Logger log = Logger.getLogger(RunTests.class);
    private Job job = null;

    public int run(String[] args) throws Exception {
        this.job = new Job(this.getConf(), JOB_NAME);
        this.job.setJarByClass(((Object)((Object)this)).getClass());
        Opts opts = new Opts();
        opts.parseArgs(RunTests.class.getName(), args, new Object[0]);
        Configuration conf = this.job.getConfiguration();
        conf.setInt("mapred.max.split.size", 40);
        conf.set("accumulo.home", System.getenv("ACCUMULO_HOME"));
        conf.setInt("mapred.task.timeout", 480000);
        conf.setBoolean("mapred.map.tasks.speculative.execution", false);
        this.job.setInputFormatClass(TextInputFormat.class);
        TextInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{new Path(opts.testFile)});
        this.job.setOutputFormatClass(TextOutputFormat.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path destination = new Path(opts.outputPath);
        if (fs.exists(destination)) {
            log.info((Object)("Deleting existing output directory " + opts.outputPath));
            fs.delete(destination, true);
        }
        TextOutputFormat.setOutputPath((Job)this.job, (Path)destination);
        this.job.setNumReduceTasks(1);
        this.job.setMapperClass(TestMapper.class);
        this.job.setOutputKeyClass(Text.class);
        this.job.setOutputValueClass(Text.class);
        this.job.setNumReduceTasks(0);
        log.info((Object)"Starting tests");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        RunTests tests = new RunTests();
        ToolRunner.run((Configuration)new Configuration(), (Tool)tests, (String[])args);
        tests.job.waitForCompletion(true);
        if (!tests.job.isSuccessful()) {
            System.exit(1);
        }
    }

    public static class TestMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        private static final String REDUCER_RESULT_START = "::::: ";
        private static final int RRS_LEN = "::::: ".length();
        private Text result = new Text();
        private static final Map<Character, Outcome> OUTCOME_COUNTERS = new HashMap<Character, Outcome>();

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            List<String> cmd = Arrays.asList("/usr/bin/python", "test/system/auto/run.py", "-m", "-t", value.toString());
            log.info((Object)("Running test " + cmd));
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(new File(context.getConfiguration().get("accumulo.home")));
            pb.redirectErrorStream(true);
            Process p = pb.start();
            p.getOutputStream().close();
            InputStream out = p.getInputStream();
            InputStreamReader outr = new InputStreamReader(out, Constants.UTF8);
            BufferedReader br = new BufferedReader(outr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    Outcome outcome;
                    log.info((Object)("More: " + line));
                    if (!line.startsWith(REDUCER_RESULT_START)) continue;
                    String resultLine = line.substring(RRS_LEN);
                    if (resultLine.length() > 0 && (outcome = OUTCOME_COUNTERS.get(Character.valueOf(resultLine.charAt(0)))) != null) {
                        context.getCounter((Enum)outcome).increment(1L);
                    }
                    String taskAttemptId = context.getTaskAttemptID().toString();
                    this.result.set(taskAttemptId + " " + resultLine);
                    context.write((Object)value, (Object)this.result);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
                context.progress();
            }
            p.waitFor();
        }

        static {
            OUTCOME_COUNTERS.put(Character.valueOf('S'), Outcome.SUCCESS);
            OUTCOME_COUNTERS.put(Character.valueOf('F'), Outcome.FAILURE);
            OUTCOME_COUNTERS.put(Character.valueOf('E'), Outcome.ERROR);
            OUTCOME_COUNTERS.put(Character.valueOf('T'), Outcome.UNEXPECTED_SUCCESS);
            OUTCOME_COUNTERS.put(Character.valueOf('G'), Outcome.EXPECTED_FAILURE);
        }

        private static enum Outcome {
            SUCCESS,
            FAILURE,
            ERROR,
            UNEXPECTED_SUCCESS,
            EXPECTED_FAILURE;

        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--tests"}, description="newline separated list of tests to run", required=true)
        String testFile;
        @Parameter(names={"--output"}, description="destination for the results of tests in HDFS", required=true)
        String outputPath;

        Opts() {
        }
    }
}

