/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.FunctionalTest;

public class RowDeleteTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        return conf;
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        FunctionalTest.TableSetup ts1 = new FunctionalTest.TableSetup("rdel1", RowDeleteTest.parseConfig(Property.TABLE_LOCALITY_GROUPS + "=lg1,dg", Property.TABLE_LOCALITY_GROUP_PREFIX + "lg1=foo", Property.TABLE_LOCALITY_GROUP_PREFIX + "dg=", Property.TABLE_ITERATOR_PREFIX + "" + IteratorUtil.IteratorScope.majc + ".rdel=30," + RowDeletingIterator.class.getName(), Property.TABLE_MAJC_RATIO + "=100"));
        return Collections.singletonList(ts1);
    }

    @Override
    public void run() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("rdel1", new BatchWriterConfig());
        bw.addMutation(RowDeleteTest.nm("r1", "foo", "cf1", "v1"));
        bw.addMutation(RowDeleteTest.nm("r1", "bar", "cf1", "v2"));
        bw.flush();
        this.getConnector().tableOperations().flush("rdel1", null, null, true);
        this.checkRFiles("rdel1", 1, 1, 1, 1);
        int count = 0;
        Scanner scanner = this.getConnector().createScanner("rdel1", Constants.NO_AUTHS);
        for (Map.Entry entry : scanner) {
            ++count;
        }
        if (count != 2) {
            throw new Exception("1 count=" + count);
        }
        bw.addMutation(RowDeleteTest.nm("r1", "", "", RowDeletingIterator.DELETE_ROW_VALUE));
        bw.flush();
        this.getConnector().tableOperations().flush("rdel1", null, null, true);
        UtilWaitThread.sleep((long)2000L);
        this.checkRFiles("rdel1", 1, 1, 2, 2);
        count = 0;
        scanner = this.getConnector().createScanner("rdel1", Constants.NO_AUTHS);
        for (Map.Entry entry : scanner) {
            ++count;
        }
        if (count != 3) {
            throw new Exception("2 count=" + count);
        }
        this.getConnector().tableOperations().compact("rdel1", null, null, false, true);
        this.checkRFiles("rdel1", 1, 1, 0, 0);
        count = 0;
        scanner = this.getConnector().createScanner("rdel1", Constants.NO_AUTHS);
        for (Map.Entry entry : scanner) {
            ++count;
        }
        if (count != 0) {
            throw new Exception("3 count=" + count);
        }
        bw.close();
    }
}

