/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class PermissionsTest {
    private static final String TEST_USER = "test_user";
    private static final PasswordToken TEST_PASS = new PasswordToken((CharSequence)"test_password");

    public static class TablePermissionsTest
    extends FunctionalTest {
        private static final Logger log = Logger.getLogger(SystemPermissionsTest.class);
        private static final String TEST_TABLE = "__TABLE_PERMISSION_TEST__";

        @Override
        public void cleanup() throws Exception {
        }

        @Override
        public Map<String, String> getInitialConfig() {
            return Collections.emptyMap();
        }

        @Override
        public List<FunctionalTest.TableSetup> getTablesToCreate() {
            return Collections.emptyList();
        }

        @Override
        public void run() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, MutationsRejectedException {
            this.getConnector().securityOperations().createLocalUser(PermissionsTest.TEST_USER, TEST_PASS);
            Connector test_user_conn = this.getInstance().getConnector(PermissionsTest.TEST_USER, (AuthenticationToken)TEST_PASS);
            TablePermissionsTest.verifyHasOnlyTheseTablePermissions(this.getConnector(), this.getConnector().whoami(), "!METADATA", TablePermission.READ, TablePermission.ALTER_TABLE);
            TablePermissionsTest.verifyHasOnlyTheseTablePermissions(this.getConnector(), PermissionsTest.TEST_USER, "!METADATA", TablePermission.READ);
            for (TablePermission perm : TablePermission.values()) {
                log.debug((Object)("Verifying the " + perm + " permission"));
                this.createTestTable();
                TablePermissionsTest.testMissingTablePermission(this.getConnector(), test_user_conn, perm);
                this.getConnector().securityOperations().grantTablePermission(PermissionsTest.TEST_USER, TEST_TABLE, perm);
                TablePermissionsTest.verifyHasOnlyTheseTablePermissions(this.getConnector(), PermissionsTest.TEST_USER, TEST_TABLE, perm);
                TablePermissionsTest.testGrantedTablePermission(this.getConnector(), test_user_conn, perm);
                this.createTestTable();
                this.getConnector().securityOperations().revokeTablePermission(PermissionsTest.TEST_USER, TEST_TABLE, perm);
                TablePermissionsTest.verifyHasNoTablePermissions(this.getConnector(), PermissionsTest.TEST_USER, TEST_TABLE, perm);
            }
        }

        private void createTestTable() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, MutationsRejectedException {
            if (!this.getConnector().tableOperations().exists(TEST_TABLE)) {
                this.getConnector().tableOperations().create(TEST_TABLE);
                BatchWriter writer = this.getConnector().createBatchWriter(TEST_TABLE, new BatchWriterConfig());
                Mutation m = new Mutation(new Text("row"));
                m.put(new Text("cf"), new Text("cq"), new Value("val".getBytes(Constants.UTF8)));
                writer.addMutation(m);
                writer.close();
                TablePermissionsTest.verifyHasOnlyTheseTablePermissions(this.getConnector(), this.getConnector().whoami(), TEST_TABLE, TablePermission.values());
                TablePermissionsTest.verifyHasNoTablePermissions(this.getConnector(), PermissionsTest.TEST_USER, TEST_TABLE, TablePermission.values());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void testMissingTablePermission(Connector root_conn, Connector test_user_conn, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
            log.debug((Object)("Confirming that the lack of the " + perm + " permission properly restricts the user"));
            switch (perm) {
                case READ: {
                    try {
                        Scanner scanner = test_user_conn.createScanner(TEST_TABLE, Constants.NO_AUTHS);
                        int i = 0;
                        for (Map.Entry entry : scanner) {
                            i += 1 + ((Key)entry.getKey()).getRowData().length();
                        }
                        if (i == 0) return;
                        throw new IllegalStateException("Should NOT be able to read from the table");
                    }
                    catch (RuntimeException e) {
                        AccumuloSecurityException se = (AccumuloSecurityException)e.getCause();
                        if (se.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                        throw se;
                    }
                }
                case WRITE: {
                    try {
                        BatchWriter writer = test_user_conn.createBatchWriter(TEST_TABLE, new BatchWriterConfig());
                        Mutation m = new Mutation(new Text("row"));
                        m.put(new Text("a"), new Text("b"), new Value("c".getBytes(Constants.UTF8)));
                        writer.addMutation(m);
                        try {
                            writer.close();
                            throw new IllegalStateException("Should NOT be able to write to a table");
                        }
                        catch (MutationsRejectedException e1) {
                            if (e1.getAuthorizationFailuresMap().size() <= 0) throw new IllegalStateException("Should NOT be able to write to a table");
                            throw new AccumuloSecurityException(test_user_conn.whoami(), org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode.PERMISSION_DENIED, (Throwable)e1);
                        }
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                        throw e;
                    }
                }
                case BULK_IMPORT: {
                    return;
                }
                case ALTER_TABLE: {
                    HashMap<String, HashSet<Text>> groups = new HashMap<String, HashSet<Text>>();
                    groups.put("tgroup", new HashSet<Text>(Arrays.asList(new Text("t1"), new Text("t2"))));
                    try {
                        test_user_conn.tableOperations().setLocalityGroups(TEST_TABLE, groups);
                        throw new IllegalStateException("User should not be able to set locality groups");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                        throw e;
                    }
                }
                case DROP_TABLE: {
                    try {
                        test_user_conn.tableOperations().delete(TEST_TABLE);
                        throw new IllegalStateException("User should not be able delete the table");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                        throw e;
                    }
                }
                case GRANT: {
                    try {
                        test_user_conn.securityOperations().grantTablePermission("root", TEST_TABLE, TablePermission.GRANT);
                        throw new IllegalStateException("User should not be able grant permissions");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED) return;
                        throw e;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized table Permission: " + perm);
                }
            }
        }

        private static void testGrantedTablePermission(Connector root_conn, Connector test_user_conn, TablePermission perm) throws AccumuloException, TableExistsException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException {
            log.debug((Object)("Confirming that the presence of the " + perm + " permission properly permits the user"));
            switch (perm) {
                case READ: {
                    Scanner scanner = test_user_conn.createScanner(TEST_TABLE, Constants.NO_AUTHS);
                    Iterator iter = scanner.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                    }
                    break;
                }
                case WRITE: {
                    BatchWriter writer = test_user_conn.createBatchWriter(TEST_TABLE, new BatchWriterConfig());
                    Mutation m = new Mutation(new Text("row"));
                    m.put(new Text("a"), new Text("b"), new Value("c".getBytes(Constants.UTF8)));
                    writer.addMutation(m);
                    writer.close();
                    break;
                }
                case BULK_IMPORT: {
                    break;
                }
                case ALTER_TABLE: {
                    HashMap<String, HashSet<Text>> groups = new HashMap<String, HashSet<Text>>();
                    groups.put("tgroup", new HashSet<Text>(Arrays.asList(new Text("t1"), new Text("t2"))));
                    break;
                }
                case DROP_TABLE: {
                    test_user_conn.tableOperations().delete(TEST_TABLE);
                    break;
                }
                case GRANT: {
                    test_user_conn.securityOperations().grantTablePermission("root", TEST_TABLE, TablePermission.GRANT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized table Permission: " + perm);
                }
            }
        }

        private static void verifyHasOnlyTheseTablePermissions(Connector root_conn, String user, String table, TablePermission ... perms) throws AccumuloException, AccumuloSecurityException {
            List<TablePermission> permList = Arrays.asList(perms);
            for (TablePermission p : TablePermission.values()) {
                if (permList.contains(p)) {
                    if (root_conn.securityOperations().hasTablePermission(user, table, p)) continue;
                    throw new IllegalStateException(user + " SHOULD have table permission " + p + " for table " + table);
                }
                if (!root_conn.securityOperations().hasTablePermission(user, table, p)) continue;
                throw new IllegalStateException(user + " SHOULD NOT have table permission " + p + " for table " + table);
            }
        }

        private static void verifyHasNoTablePermissions(Connector root_conn, String user, String table, TablePermission ... perms) throws AccumuloException, AccumuloSecurityException {
            for (TablePermission p : perms) {
                if (!root_conn.securityOperations().hasTablePermission(user, table, p)) continue;
                throw new IllegalStateException(user + " SHOULD NOT have table permission " + p + " for table " + table);
            }
        }
    }

    public static class SystemPermissionsTest
    extends FunctionalTest {
        private static final Logger log = Logger.getLogger(SystemPermissionsTest.class);

        @Override
        public void cleanup() throws Exception {
        }

        @Override
        public Map<String, String> getInitialConfig() {
            return Collections.emptyMap();
        }

        @Override
        public List<FunctionalTest.TableSetup> getTablesToCreate() {
            return Collections.emptyList();
        }

        @Override
        public void run() throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
            SystemPermissionsTest.verifyHasOnlyTheseSystemPermissions(this.getConnector(), this.getConnector().whoami(), SystemPermission.values());
            this.getConnector().securityOperations().createLocalUser(PermissionsTest.TEST_USER, TEST_PASS);
            Connector test_user_conn = this.getInstance().getConnector(PermissionsTest.TEST_USER, (AuthenticationToken)TEST_PASS);
            SystemPermissionsTest.verifyHasNoSystemPermissions(this.getConnector(), PermissionsTest.TEST_USER, SystemPermission.values());
            for (SystemPermission perm : SystemPermission.values()) {
                log.debug((Object)("Verifying the " + perm + " permission"));
                if (perm.equals((Object)SystemPermission.GRANT)) {
                    try {
                        this.getConnector().securityOperations().grantSystemPermission(PermissionsTest.TEST_USER, perm);
                    }
                    catch (AccumuloSecurityException e) {
                        SystemPermissionsTest.verifyHasNoSystemPermissions(this.getConnector(), PermissionsTest.TEST_USER, perm);
                        continue;
                    }
                    throw new IllegalStateException("Should NOT be able to grant GRANT");
                }
                SystemPermissionsTest.testMissingSystemPermission(this.getConnector(), test_user_conn, perm);
                this.getConnector().securityOperations().grantSystemPermission(PermissionsTest.TEST_USER, perm);
                SystemPermissionsTest.verifyHasOnlyTheseSystemPermissions(this.getConnector(), PermissionsTest.TEST_USER, perm);
                SystemPermissionsTest.testGrantedSystemPermission(this.getConnector(), test_user_conn, perm);
                this.getConnector().securityOperations().revokeSystemPermission(PermissionsTest.TEST_USER, perm);
                SystemPermissionsTest.verifyHasNoSystemPermissions(this.getConnector(), PermissionsTest.TEST_USER, perm);
            }
        }

        private static void testMissingSystemPermission(Connector root_conn, Connector test_user_conn, SystemPermission perm) throws AccumuloException, TableExistsException, AccumuloSecurityException, TableNotFoundException {
            String password = "password";
            log.debug((Object)("Confirming that the lack of the " + perm + " permission properly restricts the user"));
            switch (perm) {
                case CREATE_TABLE: {
                    String tableName = "__CREATE_TABLE_WITHOUT_PERM_TEST__";
                    try {
                        test_user_conn.tableOperations().create(tableName);
                        throw new IllegalStateException("Should NOT be able to create a table");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && !root_conn.tableOperations().list().contains(tableName)) break;
                        throw e;
                    }
                }
                case DROP_TABLE: {
                    String tableName = "__DROP_TABLE_WITHOUT_PERM_TEST__";
                    root_conn.tableOperations().create(tableName);
                    try {
                        test_user_conn.tableOperations().delete(tableName);
                        throw new IllegalStateException("Should NOT be able to delete a table");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.tableOperations().list().contains(tableName)) break;
                        throw e;
                    }
                }
                case ALTER_TABLE: {
                    String tableName = "__ALTER_TABLE_WITHOUT_PERM_TEST__";
                    root_conn.tableOperations().create(tableName);
                    String tableId = (String)Tables.getNameToIdMap((Instance)root_conn.getInstance()).get(tableName);
                    try {
                        test_user_conn.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                        throw new IllegalStateException("Should NOT be able to set a table property");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || ServerConfiguration.getTableConfiguration((Instance)root_conn.getInstance(), (String)tableId).get(Property.TABLE_BLOOM_ERRORRATE).equals("003.14159%")) {
                            throw e;
                        }
                        root_conn.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                        try {
                            test_user_conn.tableOperations().removeProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey());
                            throw new IllegalStateException("Should NOT be able to remove a table property");
                        }
                        catch (AccumuloSecurityException e2) {
                            if (e2.getSecurityErrorCode() != SecurityErrorCode.PERMISSION_DENIED || !ServerConfiguration.getTableConfiguration((Instance)root_conn.getInstance(), (String)tableId).get(Property.TABLE_BLOOM_ERRORRATE).equals("003.14159%")) {
                                throw e2;
                            }
                            String table2 = tableName + "2";
                            try {
                                test_user_conn.tableOperations().rename(tableName, table2);
                                throw new IllegalStateException("Should NOT be able to rename a table");
                            }
                            catch (AccumuloSecurityException e3) {
                                if (e3.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.tableOperations().list().contains(tableName) && !root_conn.tableOperations().list().contains(table2)) break;
                                throw e3;
                            }
                        }
                    }
                }
                case CREATE_USER: {
                    String user = "__CREATE_USER_WITHOUT_PERM_TEST__";
                    try {
                        test_user_conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)password));
                        throw new IllegalStateException("Should NOT be able to create a user");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && !root_conn.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                        throw e;
                    }
                }
                case DROP_USER: {
                    String user = "__DROP_USER_WITHOUT_PERM_TEST__";
                    root_conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)password));
                    try {
                        test_user_conn.securityOperations().dropLocalUser(user);
                        throw new IllegalStateException("Should NOT be able to delete a user");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                        throw e;
                    }
                }
                case ALTER_USER: {
                    String user = "__ALTER_USER_WITHOUT_PERM_TEST__";
                    root_conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)password));
                    try {
                        test_user_conn.securityOperations().changeUserAuthorizations(user, new Authorizations(new String[]{"A", "B"}));
                        throw new IllegalStateException("Should NOT be able to alter a user");
                    }
                    catch (AccumuloSecurityException e) {
                        if (e.getSecurityErrorCode() == SecurityErrorCode.PERMISSION_DENIED && root_conn.securityOperations().getUserAuthorizations(user).isEmpty()) break;
                        throw e;
                    }
                }
                case SYSTEM: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized System Permission: " + perm);
                }
            }
        }

        private static void testGrantedSystemPermission(Connector root_conn, Connector test_user_conn, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
            String password = "password";
            log.debug((Object)("Confirming that the presence of the " + perm + " permission properly permits the user"));
            switch (perm) {
                case CREATE_TABLE: {
                    String tableName = "__CREATE_TABLE_WITH_PERM_TEST__";
                    test_user_conn.tableOperations().create(tableName);
                    if (root_conn.tableOperations().list().contains(tableName)) break;
                    throw new IllegalStateException("Should be able to create a table");
                }
                case DROP_TABLE: {
                    String tableName = "__DROP_TABLE_WITH_PERM_TEST__";
                    root_conn.tableOperations().create(tableName);
                    test_user_conn.tableOperations().delete(tableName);
                    if (!root_conn.tableOperations().list().contains(tableName)) break;
                    throw new IllegalStateException("Should be able to delete a table");
                }
                case ALTER_TABLE: {
                    String tableName = "__ALTER_TABLE_WITH_PERM_TEST__";
                    String table2 = tableName + "2";
                    root_conn.tableOperations().create(tableName);
                    String tableId = (String)Tables.getNameToIdMap((Instance)root_conn.getInstance()).get(tableName);
                    Instance instance = root_conn.getInstance();
                    test_user_conn.tableOperations().setProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey(), "003.14159%");
                    if (!ServerConfiguration.getTableConfiguration((Instance)instance, (String)tableId).get(Property.TABLE_BLOOM_ERRORRATE).equals("003.14159%")) {
                        throw new IllegalStateException("Should be able to set a table property");
                    }
                    test_user_conn.tableOperations().removeProperty(tableName, Property.TABLE_BLOOM_ERRORRATE.getKey());
                    if (ServerConfiguration.getTableConfiguration((Instance)instance, (String)tableId).get(Property.TABLE_BLOOM_ERRORRATE).equals("003.14159%")) {
                        throw new IllegalStateException("Should be able to remove a table property");
                    }
                    test_user_conn.tableOperations().rename(tableName, table2);
                    if (!root_conn.tableOperations().list().contains(tableName) && root_conn.tableOperations().list().contains(table2)) break;
                    throw new IllegalStateException("Should be able to rename a table");
                }
                case CREATE_USER: {
                    String user = "__CREATE_USER_WITH_PERM_TEST__";
                    test_user_conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)password));
                    if (root_conn.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                    throw new IllegalStateException("Should be able to create a user");
                }
                case DROP_USER: {
                    String user = "__DROP_USER_WITH_PERM_TEST__";
                    root_conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)password));
                    test_user_conn.securityOperations().dropLocalUser(user);
                    if (!root_conn.securityOperations().authenticateUser(user, (AuthenticationToken)new PasswordToken((CharSequence)password))) break;
                    throw new IllegalStateException("Should be able to delete a user");
                }
                case ALTER_USER: {
                    String user = "__ALTER_USER_WITH_PERM_TEST__";
                    root_conn.securityOperations().createLocalUser(user, new PasswordToken((CharSequence)password));
                    test_user_conn.securityOperations().changeUserAuthorizations(user, new Authorizations(new String[]{"A", "B"}));
                    if (!root_conn.securityOperations().getUserAuthorizations(user).isEmpty()) break;
                    throw new IllegalStateException("Should be able to alter a user");
                }
                case SYSTEM: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized System Permission: " + perm);
                }
            }
        }

        private static void verifyHasOnlyTheseSystemPermissions(Connector root_conn, String user, SystemPermission ... perms) throws AccumuloException, AccumuloSecurityException {
            List<SystemPermission> permList = Arrays.asList(perms);
            for (SystemPermission p : SystemPermission.values()) {
                if (permList.contains(p)) {
                    if (root_conn.securityOperations().hasSystemPermission(user, p)) continue;
                    throw new IllegalStateException(user + " SHOULD have system permission " + p);
                }
                if (!root_conn.securityOperations().hasSystemPermission(user, p)) continue;
                throw new IllegalStateException(user + " SHOULD NOT have system permission " + p);
            }
        }

        private static void verifyHasNoSystemPermissions(Connector root_conn, String user, SystemPermission ... perms) throws AccumuloException, AccumuloSecurityException {
            for (SystemPermission p : perms) {
                if (!root_conn.securityOperations().hasSystemPermission(user, p)) continue;
                throw new IllegalStateException(user + " SHOULD NOT have system permission " + p);
            }
        }
    }
}

