/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.tabletserver.NativeMap;
import org.apache.hadoop.io.Text;

public class NativeMapTest {
    private void assertTrue(boolean b) {
        if (!b) {
            throw new RuntimeException();
        }
    }

    private void assertEquals(Object o1, Object o2) {
        if (!o1.equals(o2)) {
            throw new RuntimeException(o1 + " != " + o2);
        }
    }

    private void assertFalse(boolean b) {
        if (b) {
            throw new RuntimeException();
        }
    }

    private void assertNotNull(Object o) {
        if (o == null) {
            throw new RuntimeException();
        }
    }

    private void assertNull(Object o) {
        if (o != null) {
            throw new RuntimeException();
        }
    }

    public static void main(String[] args) throws Exception {
        NativeMapTest nmt = new NativeMapTest();
        nmt.setUp();
        nmt.test1();
        nmt.test2();
        nmt.test4();
        nmt.test5();
        nmt.test7();
        nmt.test8();
        nmt.test9();
        nmt.test10();
        nmt.test11();
        nmt.testBinary();
        nmt.testEmpty();
        nmt.testConcurrentIter();
    }

    private Key nk(int r) {
        return new Key(new Text(String.format("r%09d", r)));
    }

    private Key nk(int r, int cf, int cq, int cv, int ts, boolean deleted) {
        Key k = new Key(new Text(String.format("r%09d", r)), new Text(String.format("cf%09d", cf)), new Text(String.format("cq%09d", cq)), new Text(String.format("cv%09d", cv)), (long)ts);
        k.setDeleted(deleted);
        return k;
    }

    private Value nv(int v) {
        return new Value(String.format("r%09d", v).getBytes(Constants.UTF8));
    }

    public void setUp() {
        if (!NativeMap.loadedNativeLibraries()) {
            File nativeLib;
            File f;
            for (f = new File(System.getProperty("user.dir")); f != null && !(nativeLib = new File(f, NativeMap.getNativeLibPath())).exists(); f = f.getParentFile()) {
            }
            if (f != null) {
                nativeLib = new File(f, NativeMap.getNativeLibPath());
                NativeMap.loadNativeLib((String)nativeLib.toString());
            }
        }
    }

    private void verifyIterator(int start, int end, int valueOffset, Iterator<Map.Entry<Key, Value>> iter) {
        for (int i = start; i <= end; ++i) {
            this.assertTrue(iter.hasNext());
            Map.Entry<Key, Value> entry = iter.next();
            this.assertEquals(this.nk(i), entry.getKey());
            this.assertEquals(this.nv(i + valueOffset), entry.getValue());
        }
        this.assertFalse(iter.hasNext());
    }

    private void insertAndVerify(NativeMap nm, int start, int end, int valueOffset) {
        int i;
        for (i = start; i <= end; ++i) {
            nm.put(this.nk(i), this.nv(i + valueOffset));
        }
        for (i = start; i <= end; ++i) {
            Value v = nm.get(this.nk(i));
            this.assertNotNull(v);
            this.assertEquals(this.nv(i + valueOffset), v);
            Iterator iter2 = nm.iterator(this.nk(i));
            this.assertTrue(iter2.hasNext());
            Map.Entry entry = (Map.Entry)iter2.next();
            this.assertEquals(this.nk(i), entry.getKey());
            this.assertEquals(this.nv(i + valueOffset), entry.getValue());
        }
        this.assertNull(nm.get(this.nk(start - 1)));
        this.assertNull(nm.get(this.nk(end + 1)));
        Iterator iter = nm.iterator();
        this.verifyIterator(start, end, valueOffset, iter);
        for (int i2 = start; i2 <= end; ++i2) {
            iter = nm.iterator(this.nk(i2));
            this.verifyIterator(i2, end, valueOffset, iter);
            iter = nm.iterator(this.nk(i2, 1, 1, 1, 1, false));
            this.verifyIterator(i2 + 1, end, valueOffset, iter);
        }
        this.assertEquals(end - start + 1, nm.size());
    }

    private void insertAndVerifyExhaustive(NativeMap nm, int num, int run) {
        Value value;
        Key key;
        int l;
        int k;
        int j;
        int i;
        for (int i2 = 0; i2 < num; ++i2) {
            for (int j2 = 0; j2 < num; ++j2) {
                for (int k2 = 0; k2 < num; ++k2) {
                    for (int l2 = 0; l2 < num; ++l2) {
                        for (int ts = 0; ts < num; ++ts) {
                            Key key2 = this.nk(i2, j2, k2, l2, ts, true);
                            Value value2 = new Value((i2 + "_" + j2 + "_" + k2 + "_" + l2 + "_" + ts + "_" + true + "_" + run).getBytes(Constants.UTF8));
                            nm.put(key2, value2);
                            key2 = this.nk(i2, j2, k2, l2, ts, false);
                            value2 = new Value((i2 + "_" + j2 + "_" + k2 + "_" + l2 + "_" + ts + "_" + false + "_" + run).getBytes(Constants.UTF8));
                            nm.put(key2, value2);
                        }
                    }
                }
            }
        }
        Iterator iter = nm.iterator();
        for (i = 0; i < num; ++i) {
            for (j = 0; j < num; ++j) {
                for (k = 0; k < num; ++k) {
                    for (l = 0; l < num; ++l) {
                        for (int ts = num - 1; ts >= 0; --ts) {
                            key = this.nk(i, j, k, l, ts, true);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + true + "_" + run).getBytes(Constants.UTF8));
                            this.assertTrue(iter.hasNext());
                            Map.Entry entry = (Map.Entry)iter.next();
                            this.assertEquals(key, entry.getKey());
                            this.assertEquals(value, entry.getValue());
                            key = this.nk(i, j, k, l, ts, false);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + false + "_" + run).getBytes(Constants.UTF8));
                            this.assertTrue(iter.hasNext());
                            entry = (Map.Entry)iter.next();
                            this.assertEquals(key, entry.getKey());
                            this.assertEquals(value, entry.getValue());
                        }
                    }
                }
            }
        }
        this.assertFalse(iter.hasNext());
        for (i = 0; i < num; ++i) {
            for (j = 0; j < num; ++j) {
                for (k = 0; k < num; ++k) {
                    for (l = 0; l < num; ++l) {
                        for (int ts = 0; ts < num; ++ts) {
                            key = this.nk(i, j, k, l, ts, true);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + true + "_" + run).getBytes(Constants.UTF8));
                            this.assertEquals(value, nm.get(key));
                            Iterator iter2 = nm.iterator(key);
                            this.assertTrue(iter2.hasNext());
                            Map.Entry entry = (Map.Entry)iter2.next();
                            this.assertEquals(key, entry.getKey());
                            this.assertEquals(value, entry.getValue());
                            key = this.nk(i, j, k, l, ts, false);
                            value = new Value((i + "_" + j + "_" + k + "_" + l + "_" + ts + "_" + false + "_" + run).getBytes(Constants.UTF8));
                            this.assertEquals(value, nm.get(key));
                            Iterator iter3 = nm.iterator(key);
                            this.assertTrue(iter3.hasNext());
                            Map.Entry entry2 = (Map.Entry)iter3.next();
                            this.assertEquals(key, entry2.getKey());
                            this.assertEquals(value, entry2.getValue());
                        }
                    }
                }
            }
        }
        this.assertEquals(num * num * num * num * num * 2, nm.size());
    }

    public void test1() {
        NativeMap nm = new NativeMap();
        Iterator iter = nm.iterator();
        this.assertFalse(iter.hasNext());
        nm.delete();
    }

    public void test2() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        this.insertAndVerify(nm, 1, 10, 1);
        this.insertAndVerify(nm, 1, 10, 2);
        nm.delete();
    }

    public void test4() {
        NativeMap nm = new NativeMap();
        this.insertAndVerifyExhaustive(nm, 3, 0);
        this.insertAndVerifyExhaustive(nm, 3, 1);
        nm.delete();
    }

    public void test5() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        Iterator iter = nm.iterator();
        iter.next();
        nm.delete();
        try {
            nm.put(this.nk(1), this.nv(1));
            this.assertTrue(false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            nm.get(this.nk(1));
            this.assertTrue(false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            nm.iterator();
            this.assertTrue(false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            nm.iterator(this.nk(1));
            this.assertTrue(false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            nm.size();
            this.assertTrue(false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            iter.next();
            this.assertTrue(false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test7() {
        NativeMap nm = new NativeMap();
        this.insertAndVerify(nm, 1, 10, 0);
        nm.delete();
        try {
            nm.delete();
            this.assertTrue(false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test8() {
        NativeMap nm = new NativeMap();
        TreeMap<Key, Value> tm = new TreeMap<Key, Value>();
        tm.put(new Key(new Text("fo")), new Value(new byte[]{48}));
        tm.put(new Key(new Text("foo")), new Value(new byte[]{49}));
        tm.put(new Key(new Text("foo1")), new Value(new byte[]{50}));
        tm.put(new Key(new Text("foo2")), new Value(new byte[]{51}));
        for (Map.Entry entry : tm.entrySet()) {
            nm.put((Key)entry.getKey(), (Value)entry.getValue());
        }
        Iterator iter = nm.iterator();
        for (Map.Entry entry : tm.entrySet()) {
            this.assertTrue(iter.hasNext());
            Map.Entry entry2 = (Map.Entry)iter.next();
            this.assertEquals(entry.getKey(), entry2.getKey());
            this.assertEquals(entry.getValue(), entry2.getValue());
        }
        this.assertFalse(iter.hasNext());
        nm.delete();
    }

    public void test9() {
        NativeMap nm = new NativeMap();
        Iterator iter = nm.iterator();
        try {
            iter.next();
            this.assertTrue(false);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        this.insertAndVerify(nm, 1, 1, 0);
        iter = nm.iterator();
        iter.next();
        try {
            iter.next();
            this.assertTrue(false);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        nm.delete();
    }

    public void test10() {
        int start = 1;
        int end = 10000;
        NativeMap nm = new NativeMap();
        for (int i = start; i <= end; ++i) {
            nm.put(this.nk(i), this.nv(i));
        }
        long mem1 = nm.getMemoryUsed();
        for (int i = start; i <= end; ++i) {
            nm.put(this.nk(i), this.nv(i));
        }
        long mem2 = nm.getMemoryUsed();
        if (mem1 != mem2) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem1 + " " + mem2);
        }
        for (int i = start; i <= end; ++i) {
            nm.put(this.nk(i), this.nv(i));
        }
        long mem3 = nm.getMemoryUsed();
        if (mem1 != mem3) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem1 + " " + mem3);
        }
        byte[] bigrow = new byte[1000000];
        byte[] bigvalue = new byte[bigrow.length];
        for (int i = 0; i < bigrow.length; ++i) {
            bigrow[i] = (byte)(0xFF & i % 256);
            bigvalue[i] = bigrow[i];
        }
        nm.put(new Key(new Text(bigrow)), new Value(bigvalue));
        long mem4 = nm.getMemoryUsed();
        Value val = nm.get(new Key(new Text(bigrow)));
        if (val == null || !val.equals((Object)new Value(bigvalue))) {
            throw new RuntimeException("Did not get expected big value");
        }
        nm.put(new Key(new Text(bigrow)), new Value(bigvalue));
        long mem5 = nm.getMemoryUsed();
        if (mem4 != mem5) {
            throw new RuntimeException("Memory changed after inserting duplicate data " + mem4 + " " + mem5);
        }
        val = nm.get(new Key(new Text(bigrow)));
        if (val == null || !val.equals((Object)new Value(bigvalue))) {
            throw new RuntimeException("Did not get expected big value");
        }
        nm.delete();
    }

    private static byte[] rlrf(Random r, int maxLen) {
        int len = r.nextInt(maxLen);
        byte[] f = new byte[len];
        r.nextBytes(f);
        return f;
    }

    public void test11() {
        NativeMap nm = new NativeMap();
        Random r = new Random(75L);
        ArrayList<Pair> testData = new ArrayList<Pair>();
        for (int i = 0; i < 100000; ++i) {
            Key k = new Key(NativeMapTest.rlrf(r, 97), NativeMapTest.rlrf(r, 13), NativeMapTest.rlrf(r, 31), NativeMapTest.rlrf(r, 11), r.nextLong() & Long.MAX_VALUE, false, false);
            Value v = new Value(NativeMapTest.rlrf(r, 511));
            testData.add(new Pair((Object)k, (Object)v));
        }
        for (Pair pair : testData) {
            nm.put((Key)pair.getFirst(), (Value)pair.getSecond());
        }
        for (int i = 0; i < 2; ++i) {
            Collections.sort(testData, new Comparator<Pair<Key, Value>>(){

                @Override
                public int compare(Pair<Key, Value> o1, Pair<Key, Value> o2) {
                    return ((Key)o1.getFirst()).compareTo((Key)o2.getFirst());
                }
            });
            Iterator iter1 = nm.iterator();
            Iterator iter2 = testData.iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                Map.Entry e = (Map.Entry)iter1.next();
                Pair p = (Pair)iter2.next();
                if (!((Key)e.getKey()).equals(p.getFirst())) {
                    throw new RuntimeException("Keys not equal");
                }
                if (((Value)e.getValue()).equals(p.getSecond())) continue;
                throw new RuntimeException("Values not equal");
            }
            if (iter1.hasNext()) {
                throw new RuntimeException("Not all of native map consumed");
            }
            if (iter2.hasNext()) {
                throw new RuntimeException("Not all of test data consumed");
            }
            System.out.println("test 11 nm mem " + nm.getMemoryUsed());
            Collections.shuffle(testData, r);
            for (Pair pair : testData) {
                ((Value)pair.getSecond()).set(NativeMapTest.rlrf(r, 511));
                nm.put((Key)pair.getFirst(), (Value)pair.getSecond());
            }
        }
        nm.delete();
    }

    public void testBinary() {
        Value v;
        Key k;
        byte[] data;
        byte[] row;
        int i;
        NativeMap nm = new NativeMap();
        byte[] emptyBytes = new byte[]{};
        for (int i2 = 0; i2 < 256; ++i2) {
            for (int j = 0; j < 256; ++j) {
                byte[] row2 = new byte[]{114, (byte)(0xFF & i2), (byte)(0xFF & j)};
                byte[] data2 = new byte[]{118, (byte)(0xFF & i2), (byte)(0xFF & j)};
                Key k2 = new Key(row2, emptyBytes, emptyBytes, emptyBytes, 1L);
                Value v2 = new Value(data2);
                nm.put(k2, v2);
            }
        }
        Iterator iter = nm.iterator();
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                row = new byte[]{114, (byte)(0xFF & i), (byte)(0xFF & j)};
                data = new byte[]{118, (byte)(0xFF & i), (byte)(0xFF & j)};
                k = new Key(row, emptyBytes, emptyBytes, emptyBytes, 1L);
                v = new Value(data);
                this.assertTrue(iter.hasNext());
                Map.Entry entry = (Map.Entry)iter.next();
                this.assertEquals(k, entry.getKey());
                this.assertEquals(v, entry.getValue());
            }
        }
        this.assertFalse(iter.hasNext());
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                row = new byte[]{114, (byte)(0xFF & i), (byte)(0xFF & j)};
                data = new byte[]{118, (byte)(0xFF & i), (byte)(0xFF & j)};
                k = new Key(row, emptyBytes, emptyBytes, emptyBytes, 1L);
                v = new Value(data);
                Value v2 = nm.get(k);
                this.assertEquals(v, v2);
            }
        }
        nm.delete();
    }

    public void testEmpty() {
        NativeMap nm = new NativeMap();
        this.assertTrue(nm.size() == 0);
        this.assertTrue(nm.getMemoryUsed() == 0L);
        nm.delete();
    }

    public void testConcurrentIter() throws IOException {
        NativeMap nm = new NativeMap();
        nm.put(this.nk(0), this.nv(0));
        nm.put(this.nk(1), this.nv(1));
        nm.put(this.nk(3), this.nv(3));
        SortedKeyValueIterator iter = nm.skvIterator();
        nm.put(this.nk(2), this.nv(2));
        this.assertTrue(iter.hasTop());
        this.assertEquals(iter.getTopKey(), this.nk(0));
        iter.next();
        this.assertTrue(iter.hasTop());
        this.assertEquals(iter.getTopKey(), this.nk(1));
        iter.next();
        this.assertTrue(iter.hasTop());
        this.assertEquals(iter.getTopKey(), this.nk(2));
        iter.next();
        this.assertTrue(iter.hasTop());
        this.assertEquals(iter.getTopKey(), this.nk(3));
        iter.next();
        this.assertFalse(iter.hasTop());
        nm.delete();
    }
}

