/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class MergeTest
extends FunctionalTest {
    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    private String[] ns(String ... strings) {
        return strings;
    }

    @Override
    public void run() throws Exception {
        int tc = 0;
        this.runMergeTest("foo" + tc++, this.ns(new String[0]), this.ns(new String[0]), this.ns("l", "m", "n"), this.ns(null, "l"), this.ns(null, "n"));
        this.runMergeTest("foo" + tc++, this.ns("m"), this.ns(new String[0]), this.ns("l", "m", "n"), this.ns(null, "l"), this.ns(null, "n"));
        this.runMergeTest("foo" + tc++, this.ns("m"), this.ns("m"), this.ns("l", "m", "n"), this.ns("m", "n"), this.ns(null, "z"));
        this.runMergeTest("foo" + tc++, this.ns("m"), this.ns("m"), this.ns("l", "m", "n"), this.ns(null, "b"), this.ns("l", "m"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns(new String[0]), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns(null, "s"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("c", "m"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("n", "r"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("b"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns(null, "s"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("b", "m"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("m", "n"), this.ns(null, "s"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("b", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns("q", "r"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns(null, "a"), this.ns("aa", "b"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("r", "s"), this.ns(null, "z"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("b", "c"), this.ns("l", "m"));
        this.runMergeTest("foo" + tc++, this.ns("b", "m", "r"), this.ns("b", "m", "r"), this.ns("a", "b", "c", "l", "m", "n", "q", "r", "s"), this.ns("m", "n"), this.ns("q", "r"));
    }

    private void runMergeTest(String table, String[] splits, String[] expectedSplits, String[] inserts, String[] start, String[] end) throws Exception {
        int count = 0;
        for (String s : start) {
            for (String e : end) {
                this.runMergeTest(table + "_" + count++, splits, expectedSplits, inserts, s, e);
            }
        }
    }

    private void runMergeTest(String table, String[] splits, String[] expectedSplits, String[] inserts, String start, String end) throws Exception {
        System.out.println("Running merge test " + table + " " + Arrays.asList(splits) + " " + start + " " + end);
        Connector conn = super.getConnector();
        conn.tableOperations().create(table, true, TimeType.LOGICAL);
        TreeSet<Text> splitSet = new TreeSet<Text>();
        for (String split : splits) {
            splitSet.add(new Text(split));
        }
        conn.tableOperations().addSplits(table, splitSet);
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        HashSet<String> expected = new HashSet<String>();
        for (String row : inserts) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)row);
            bw.addMutation(m);
            expected.add(row);
        }
        bw.close();
        conn.tableOperations().merge(table, start == null ? null : new Text(start), end == null ? null : new Text(end));
        Scanner scanner = conn.createScanner(table, Constants.NO_AUTHS);
        HashSet<String> observed = new HashSet<String>();
        for (Map.Entry entry : scanner) {
            String row = ((Key)entry.getKey()).getRowData().toString();
            if (observed.add(row)) continue;
            throw new Exception("Saw data twice " + table + " " + row);
        }
        if (!observed.equals(expected)) {
            throw new Exception("data inconsistency " + table + " " + observed + " != " + expected);
        }
        HashSet currentSplits = new HashSet(conn.tableOperations().listSplits(table));
        HashSet<Text> ess = new HashSet<Text>();
        for (String es : expectedSplits) {
            ess.add(new Text(es));
        }
        if (!currentSplits.equals(ess)) {
            throw new Exception("split inconsistency " + table + " " + currentSplits + " != " + ess);
        }
    }

    @Override
    public void cleanup() throws Exception {
    }
}

