/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTest;

public class MaxOpenTest
extends FunctionalTest {
    private static final int NUM_TABLETS = 16;
    private static final int NUM_TO_INGEST = 10000;

    @Override
    public void cleanup() {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return MaxOpenTest.parseConfig(Property.TSERV_SCAN_MAX_OPENFILES + "=4", Property.TSERV_MAJC_MAXCONCURRENT + "=1", Property.TSERV_MAJC_THREAD_MAXOPEN + "=2");
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        Map<String, String> config = MaxOpenTest.parseConfig(Property.TABLE_MAJC_RATIO + "=10");
        FunctionalTest.TableSetup ts = new FunctionalTest.TableSetup("test_ingest", config, TestIngest.getSplitPoints(0L, 10000L, 16L));
        return Collections.singletonList(ts);
    }

    @Override
    public void run() throws Exception {
        for (int i = 0; i < 3; ++i) {
            TestIngest.main(new String[]{"-u", "root", "-p", "secret", "--random", "" + i, "--timestamp", "" + i, "--size", "50", "--rows", "10000", "--start", "0", "--cols", "1"});
            this.getConnector().tableOperations().flush("test_ingest", null, null, true);
            this.checkRFiles("test_ingest", 16, 16, i + 1, i + 1);
        }
        ArrayList<Range> ranges = new ArrayList<Range>(10000);
        for (int i = 0; i < 10000; ++i) {
            ranges.add(new Range(TestIngest.generateRow(i, 0)));
        }
        long time1 = this.batchScan(ranges, 1);
        time1 = this.batchScan(ranges, 1);
        long time2 = this.batchScan(ranges, 16);
        System.out.printf("Single thread scan time   %6.2f %n", (double)time1 / 1000.0);
        System.out.printf("Multiple thread scan time %6.2f %n", (double)time2 / 1000.0);
    }

    private long batchScan(List<Range> ranges, int threads) throws Exception {
        BatchScanner bs = this.getConnector().createBatchScanner("test_ingest", TestIngest.AUTHS, threads);
        bs.setRanges(ranges);
        int count = 0;
        long t1 = System.currentTimeMillis();
        byte[] rval = new byte[50];
        Random random = new Random();
        for (Map.Entry entry : bs) {
            ++count;
            int row = VerifyIngest.getRow((Key)entry.getKey());
            int col = VerifyIngest.getCol((Key)entry.getKey());
            if (row < 0 || row >= 10000) {
                throw new Exception("unexcepted row " + row);
            }
            rval = TestIngest.genRandomValue(random, rval, 2, row, col);
            if (((Value)entry.getValue()).compareTo(rval) == 0) continue;
            throw new Exception("unexcepted value row=" + row + " col=" + col);
        }
        long t2 = System.currentTimeMillis();
        bs.close();
        if (count != 10000) {
            throw new Exception("Batch Scan did not return expected number of values " + count);
        }
        return t2 - t1;
    }
}

