/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class LogicalTimeTest
extends FunctionalTest {
    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    @Override
    public void run() throws Exception {
        int tc = 0;
        this.runMergeTest("foo" + tc++, new String[]{"m"}, new String[]{"a"}, null, null, "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"m"}, new String[]{"z"}, null, null, "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"m"}, new String[]{"a", "z"}, null, null, "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"m"}, new String[]{"a", "c", "z"}, null, null, "b", 3L);
        this.runMergeTest("foo" + tc++, new String[]{"m"}, new String[]{"a", "y", "z"}, null, null, "b", 3L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a"}, null, null, "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"h"}, null, null, "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"s"}, null, null, "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s"}, null, null, "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a", "c", "h", "s"}, null, null, "b", 3L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s", "i"}, null, null, "b", 3L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"t", "a", "h", "s"}, null, null, "b", 3L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a"}, null, "h", "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"h"}, null, "h", "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"s"}, null, "h", "b", 1L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s"}, null, "h", "b", 2L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a", "c", "h", "s"}, null, "h", "b", 3L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"a", "h", "s", "i"}, null, "h", "b", 3L);
        this.runMergeTest("foo" + tc++, new String[]{"g", "r"}, new String[]{"t", "a", "h", "s"}, null, "h", "b", 2L);
    }

    private void runMergeTest(String table, String[] splits, String[] inserts, String start, String end, String last, long expected) throws Exception {
        Connector conn = super.getConnector();
        conn.tableOperations().create(table, true, TimeType.LOGICAL);
        TreeSet<Text> splitSet = new TreeSet<Text>();
        for (String split : splits) {
            splitSet.add(new Text(split));
        }
        conn.tableOperations().addSplits(table, splitSet);
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        for (String row : inserts) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
            bw.addMutation(m);
        }
        bw.flush();
        conn.tableOperations().merge(table, start == null ? null : new Text(start), end == null ? null : new Text(end));
        Mutation m = new Mutation((CharSequence)last);
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"v");
        bw.addMutation(m);
        bw.flush();
        Scanner scanner = conn.createScanner(table, Constants.NO_AUTHS);
        scanner.setRange(new Range((CharSequence)last));
        bw.close();
        long time = ((Key)((Map.Entry)scanner.iterator().next()).getKey()).getTimestamp();
        if (time != expected) {
            throw new RuntimeException("unexpected time " + time + " " + expected);
        }
    }

    @Override
    public void cleanup() throws Exception {
    }
}

