/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class LargeRowTest
extends FunctionalTest {
    private static final int SEED = 42;
    private static final String REG_TABLE_NAME = "lr";
    private static final String PRE_SPLIT_TABLE_NAME = "lrps";
    private static final int NUM_ROWS = 100;
    private static final int ROW_SIZE = 131072;
    private static final int NUM_PRE_SPLITS = 9;
    private static final int SPLIT_THRESH = 1456355;

    @Override
    public void cleanup() {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return LargeRowTest.parseConfig(Property.TSERV_MAJC_DELAY + "=10ms");
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        Random r = new Random();
        byte[] rowData = new byte[131072];
        r.setSeed(43L);
        TreeSet<Text> splitPoints = new TreeSet<Text>();
        for (int i = 0; i < 9; ++i) {
            r.nextBytes(rowData);
            TestIngest.toPrintableChars(rowData);
            splitPoints.add(new Text(rowData));
        }
        ArrayList<FunctionalTest.TableSetup> tables = new ArrayList<FunctionalTest.TableSetup>();
        tables.add(new FunctionalTest.TableSetup(REG_TABLE_NAME));
        tables.add(new FunctionalTest.TableSetup(PRE_SPLIT_TABLE_NAME, splitPoints));
        return tables;
    }

    @Override
    public void run() throws Exception {
        this.test1();
        this.test2();
    }

    private void test1() throws Exception {
        this.basicTest(REG_TABLE_NAME, 0);
        this.getConnector().tableOperations().setProperty(REG_TABLE_NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "1456355");
        UtilWaitThread.sleep((long)12000L);
        Logger.getLogger(LargeRowTest.class).warn((Object)"checking splits");
        this.checkSplits(REG_TABLE_NAME, 4, 36);
        this.verify(REG_TABLE_NAME);
    }

    private void test2() throws Exception {
        this.basicTest(PRE_SPLIT_TABLE_NAME, 9);
    }

    private void basicTest(String table, int expectedSplits) throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter(table, new BatchWriterConfig());
        Random r = new Random();
        byte[] rowData = new byte[131072];
        r.setSeed(42L);
        for (int i = 0; i < 100; ++i) {
            r.nextBytes(rowData);
            TestIngest.toPrintableChars(rowData);
            Mutation mut = new Mutation(new Text(rowData));
            mut.put(new Text(""), new Text(""), new Value(Integer.toString(i).getBytes(Constants.UTF8)));
            bw.addMutation(mut);
        }
        bw.close();
        this.checkSplits(table, expectedSplits, expectedSplits);
        this.verify(table);
        this.checkSplits(table, expectedSplits, expectedSplits);
        this.getConnector().tableOperations().flush(table, null, null, false);
        this.verify(table);
        this.getConnector().tableOperations().flush(table, null, null, true);
        this.checkSplits(table, expectedSplits, expectedSplits);
        this.verify(table);
        this.checkSplits(table, expectedSplits, expectedSplits);
    }

    private void verify(String table) throws Exception {
        Random r = new Random();
        byte[] rowData = new byte[131072];
        r.setSeed(42L);
        Scanner scanner = this.getConnector().createScanner(table, Constants.NO_AUTHS);
        for (int i = 0; i < 100; ++i) {
            r.nextBytes(rowData);
            TestIngest.toPrintableChars(rowData);
            scanner.setRange(new Range(new Text(rowData)));
            int count = 0;
            for (Map.Entry entry : scanner) {
                if (!((Key)entry.getKey()).getRow().equals((Object)new Text(rowData))) {
                    throw new Exception("verification failed, unexpected row i =" + i);
                }
                if (!((Value)entry.getValue()).equals((Object)Integer.toString(i).getBytes(Constants.UTF8))) {
                    throw new Exception("verification failed, unexpected value i =" + i + " value = " + entry.getValue());
                }
                ++count;
            }
            if (count == true) continue;
            throw new Exception("verification failed, unexpected count i =" + i + " count=" + count);
        }
    }
}

