/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class DeleteRowsTest
extends FunctionalTest {
    private static final Logger log = Logger.getLogger(DeleteRowsTest.class);
    private static final int ROWS_PER_TABLET = 10;
    private static final String[] LETTERS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    static final SortedSet<Text> SPLITS = new TreeSet<Text>();
    static final List<String> ROWS;

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    @Override
    public void run() throws Exception {
        int i = 0;
        this.testSplit("test" + i++, "f", "h", "abcdefijklmnopqrstuvwxyz", 260);
        this.testSplit("test" + i++, "f1", "h", "abcdeff1ijklmnopqrstuvwxyz", 262);
        this.testSplit("test" + i++, "f", "h1", "abcdefijklmnopqrstuvwxyz", 258);
        this.testSplit("test" + i++, "f1", "h1", "abcdeff1ijklmnopqrstuvwxyz", 260);
        this.testSplit("test" + i++, "f", "g", "abcdefhijklmnopqrstuvwxyz", 270);
        this.testSplit("test" + i++, "f", "f1", "abcdefghijklmnopqrstuvwxyz", 278);
        this.testSplit("test" + i++, "f1", "g", "abcdeff1hijklmnopqrstuvwxyz", 272);
        this.testSplit("test" + i++, null, "h", "ijklmnopqrstuvwxyz", 200);
        this.testSplit("test" + i++, "t", null, "abcdefghijklmnopqrst", 200);
        this.testSplit("test" + i++, "t0", "t2", "abcdefghijklmnopqrstt0uvwxyz", 278);
        this.testSplit("test" + i++, null, "A1", "abcdefghijklmnopqrstuvwxyz", 278);
        this.testSplit("test" + i++, "{1", null, "abcdefghijklmnopqrstuvwxyz{1", 272);
        this.testSplit("test" + i++, null, null, "", 0);
    }

    private void testSplit(String table, String start, String end, String result, int entries) throws Exception {
        this.getConnector().tableOperations().create(table);
        BatchWriter bw = this.getConnector().createBatchWriter(table, new BatchWriterConfig());
        for (String row : ROWS) {
            for (int j = 0; j < 10; ++j) {
                Mutation m = new Mutation((CharSequence)(row + j));
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                bw.addMutation(m);
            }
        }
        bw.flush();
        bw.close();
        this.getConnector().tableOperations().addSplits(table, SPLITS);
        Text startText = start == null ? null : new Text(start);
        Text endText = end == null ? null : new Text(end);
        this.getConnector().tableOperations().deleteRows(table, startText, endText);
        Collection remainingSplits = this.getConnector().tableOperations().listSplits(table);
        StringBuilder sb = new StringBuilder();
        for (Text split : remainingSplits) {
            sb.append(split.toString());
        }
        this.assertEquals(result, sb.toString());
        Scanner scanner = this.getConnector().createScanner(table, Constants.NO_AUTHS);
        int count = 0;
        for (Map.Entry entry : scanner) {
            Text row = ((Key)entry.getKey()).getRow();
            this.assertTrue(startText == null || row.compareTo((BinaryComparable)startText) <= 0 || endText == null || row.compareTo((BinaryComparable)endText) > 0);
            this.assertTrue(startText != null || endText != null);
            ++count;
        }
        log.info((Object)("Finished table " + table));
        this.assertEquals(entries, count);
    }

    private void assertEquals(int expected, int value) {
        if (expected != value) {
            throw new RuntimeException("Test failed, expected " + expected + " != " + value);
        }
    }

    private void assertTrue(boolean b) {
        if (!b) {
            throw new RuntimeException("test failed, false value");
        }
    }

    private void assertEquals(String expected, String value) {
        if (!expected.equals(value)) {
            throw new RuntimeException("expected " + expected + " != " + value);
        }
    }

    static {
        for (String alpha : LETTERS) {
            SPLITS.add(new Text(alpha));
        }
        ROWS = new ArrayList<String>(Arrays.asList(LETTERS));
        ROWS.add("A");
        ROWS.add("{");
    }
}

