/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class DeleteRowsSplitTest
extends FunctionalTest {
    private static final Logger log = Logger.getLogger(DeleteRowsSplitTest.class);
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";
    static final SortedSet<Text> SPLITS = new TreeSet<Text>();
    static final List<String> ROWS = new ArrayList<String>();
    static final String TABLE;

    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws Exception {
        int test = 0;
        while (test < 50) {
            log.info((Object)("Test " + test));
            this.getConnector().tableOperations().create(TABLE);
            this.fillTable(TABLE);
            Text start = new Text();
            final Text end = new Text();
            this.generateRandomRange(start, end);
            final boolean[] fail = new boolean[]{false};
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        SortedSet<Text> afterEnd = SPLITS.tailSet(new Text(end.toString() + "\u0000"));
                        DeleteRowsSplitTest.this.getConnector().tableOperations().addSplits(TABLE, afterEnd);
                        return;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex, (Throwable)ex);
                        boolean[] blArray = fail;
                        synchronized (fail) {
                            fail[0] = true;
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return;
                        }
                    }
                }
            };
            t.start();
            UtilWaitThread.sleep((long)(test * 2));
            this.getConnector().tableOperations().deleteRows(TABLE, start, end);
            t.join();
            boolean[] blArray = fail;
            // MONITORENTER : fail
            this.assertTrue(!fail[0]);
            // MONITOREXIT : blArray
            Scanner scanner = this.getConnector().createScanner(TABLE, Constants.NO_AUTHS);
            for (Map.Entry entry : scanner) {
                Text row = ((Key)entry.getKey()).getRow();
                this.assertTrue(row.compareTo((BinaryComparable)start) <= 0 || row.compareTo((BinaryComparable)end) > 0);
            }
            this.getConnector().tableOperations().delete(TABLE);
            ++test;
        }
    }

    private void generateRandomRange(Text start, Text end) {
        ArrayList<String> bunch = new ArrayList<String>(ROWS);
        Collections.shuffle(bunch);
        if (((String)bunch.get(0)).compareTo((String)bunch.get(1)) < 0) {
            start.set((String)bunch.get(0));
            end.set((String)bunch.get(1));
        } else {
            start.set((String)bunch.get(1));
            end.set((String)bunch.get(0));
        }
    }

    private void fillTable(String table) throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter(TABLE, new BatchWriterConfig());
        for (String row : ROWS) {
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
            bw.addMutation(m);
        }
        bw.close();
    }

    private void assertTrue(boolean b) {
        if (!b) {
            throw new RuntimeException("test failed, false value");
        }
    }

    static {
        for (byte b : LETTERS.getBytes(Constants.UTF8)) {
            SPLITS.add(new Text(new byte[]{b}));
            ROWS.add(new String(new byte[]{b}, Constants.UTF8));
        }
        Random random = new Random();
        TABLE = "table" + Long.toHexString(random.nextLong());
    }
}

