/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class CreateAndUseTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    @Override
    public void run() throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 1; i < 256; ++i) {
            splits.add(new Text(String.format("%08x", i << 8)));
        }
        Text cf = new Text("cf1");
        Text cq = new Text("cq1");
        this.getConnector().tableOperations().create("t1");
        this.getConnector().tableOperations().addSplits("t1", splits);
        BatchWriter bw = this.getConnector().createBatchWriter("t1", new BatchWriterConfig());
        for (int i = 1; i < 257; ++i) {
            Mutation m = new Mutation(new Text(String.format("%08x", (i << 8) - 16)));
            m.put(cf, cq, new Value(Integer.toString(i).getBytes(Constants.UTF8)));
            bw.addMutation(m);
        }
        bw.close();
        Scanner scanner1 = this.getConnector().createScanner("t1", Constants.NO_AUTHS);
        int ei = 1;
        for (Map.Entry entry : scanner1) {
            if (!((Key)entry.getKey()).getRow().toString().equals(String.format("%08x", (ei << 8) - 16))) {
                throw new Exception("Expected row " + String.format("%08x", (ei << 8) - 16) + " saw " + ((Key)entry.getKey()).getRow());
            }
            if (!((Value)entry.getValue()).toString().equals("" + ei)) {
                throw new Exception("Expected value " + ei + " saw " + entry.getValue());
            }
            ++ei;
        }
        if (ei != 257) {
            throw new Exception("Did not see expected number of rows, ei = " + ei);
        }
        this.getConnector().tableOperations().create("t2");
        this.getConnector().tableOperations().addSplits("t2", splits);
        Scanner scanner2 = this.getConnector().createScanner("t2", Constants.NO_AUTHS);
        int count = 0;
        for (Map.Entry entry : scanner2) {
            if (entry == null) continue;
            ++count;
        }
        if (count != 0) {
            throw new Exception("Did not see expected number of entries, count = " + count);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 1; i < 257; ++i) {
            ranges.add(new Range(new Text(String.format("%08x", (i << 8) - 16))));
        }
        this.getConnector().tableOperations().create("t3");
        this.getConnector().tableOperations().addSplits("t3", splits);
        BatchScanner bs = this.getConnector().createBatchScanner("t3", Constants.NO_AUTHS, 3);
        bs.setRanges(ranges);
        count = 0;
        for (Map.Entry entry : bs) {
            if (entry == null) continue;
            ++count;
        }
        if (count != 0) {
            throw new Exception("Did not see expected number of entries, count = " + count);
        }
        bs.close();
    }
}

