/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.io.Text;

public class ConcurrencyTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("tserver.compaction.major.delay", "1");
        return opts;
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        String pre = Property.TABLE_ITERATOR_PREFIX.getKey();
        FunctionalTest.TableSetup ts = new FunctionalTest.TableSetup("cct", ConcurrencyTest.parseConfig(pre + "minc.slow=30," + SlowIterator.class.getName(), pre + "minc.slow.opt.sleepTime=50", pre + "majc.slow=30," + SlowIterator.class.getName(), pre + "majc.slow.opt.sleepTime=50", Property.TABLE_MAJC_RATIO.getKey() + "=1"));
        return Collections.singletonList(ts);
    }

    @Override
    public void run() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("cct", new BatchWriterConfig());
        for (int i = 0; i < 50; ++i) {
            Mutation m = new Mutation(new Text(String.format("%06d", i)));
            m.put(new Text("cf1"), new Text("cq1"), new Value("foo".getBytes(Constants.UTF8)));
            bw.addMutation(m);
        }
        bw.flush();
        ScanTask st0 = new ScanTask(this.getConnector(), 300L);
        st0.start();
        ScanTask st1 = new ScanTask(this.getConnector(), 100L);
        st1.start();
        UtilWaitThread.sleep((long)50L);
        this.getConnector().tableOperations().flush("cct", null, null, true);
        for (int i = 0; i < 50; ++i) {
            Mutation m = new Mutation(new Text(String.format("%06d", i)));
            m.put(new Text("cf1"), new Text("cq1"), new Value("foo".getBytes(Constants.UTF8)));
            bw.addMutation(m);
        }
        bw.flush();
        ScanTask st2 = new ScanTask(this.getConnector(), 100L);
        st2.start();
        st1.join();
        st2.join();
        if (st1.count != 50) {
            throw new Exception("Thread 1 did not see 50, saw " + st1.count);
        }
        if (st2.count != 50) {
            throw new Exception("Thread 2 did not see 50, saw " + st2.count);
        }
        ScanTask st3 = new ScanTask(this.getConnector(), 150L);
        st3.start();
        UtilWaitThread.sleep((long)50L);
        this.getConnector().tableOperations().flush("cct", null, null, false);
        st3.join();
        if (st3.count != 50) {
            throw new Exception("Thread 3 did not see 50, saw " + st3.count);
        }
        st0.join();
        if (st0.count != 50) {
            throw new Exception("Thread 0 did not see 50, saw " + st0.count);
        }
        bw.close();
    }

    static class ScanTask
    extends Thread {
        int count = 0;
        Scanner scanner;

        ScanTask(Connector conn, long time) throws Exception {
            this.scanner = conn.createScanner("cct", Constants.NO_AUTHS);
            IteratorSetting slow = new IteratorSetting(30, "slow", SlowIterator.class);
            slow.addOption("sleepTime", "" + time);
            this.scanner.addScanIterator(slow);
        }

        @Override
        public void run() {
            for (Map.Entry entry : this.scanner) {
                ++this.count;
            }
        }
    }
}

