/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CleanUp;
import org.apache.accumulo.test.functional.FunctionalTest;

public class CleanUpTest
extends FunctionalTest {
    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.emptyList();
    }

    @Override
    public void run() throws Exception {
        this.getConnector().tableOperations().create("test");
        BatchWriter bw = this.getConnector().createBatchWriter("test", new BatchWriterConfig());
        Mutation m1 = new Mutation((CharSequence)"r1");
        m1.put((CharSequence)"cf1", (CharSequence)"cq1", 1L, (CharSequence)"5");
        bw.addMutation(m1);
        bw.flush();
        Scanner scanner = this.getConnector().createScanner("test", new Authorizations());
        int count = 0;
        for (Map.Entry entry : scanner) {
            ++count;
            if (((Value)entry.getValue()).toString().equals("5")) continue;
            throw new Exception("Unexpected value " + entry.getValue());
        }
        if (count != 1) {
            throw new Exception("Unexpected count " + count);
        }
        if (this.countThreads() < 2) {
            this.printThreadNames();
            throw new Exception("Not seeing expected threads");
        }
        CleanUp.shutdownNow();
        Mutation m2 = new Mutation((CharSequence)"r2");
        m2.put((CharSequence)"cf1", (CharSequence)"cq1", 1L, (CharSequence)"6");
        try {
            bw.addMutation(m1);
            bw.flush();
            throw new Exception("batch writer did not fail");
        }
        catch (Exception e) {
            try {
                bw.close();
                throw new Exception("batch writer close not fail");
            }
            catch (Exception e2) {
                try {
                    count = 0;
                    Iterator iter = scanner.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        ++count;
                    }
                    throw new Exception("scanner did not fail");
                }
                catch (Exception e3) {
                    if (this.countThreads() > 0) {
                        this.printThreadNames();
                        throw new Exception("Threads did not go away");
                    }
                    return;
                }
            }
        }
    }

    private void printThreadNames() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            System.out.println("thread name:" + thread.getName());
            thread.getStackTrace();
        }
    }

    private int countThreads() {
        int count = 0;
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            if (thread.getName().toLowerCase().contains("sendthread") || thread.getName().toLowerCase().contains("eventthread")) {
                ++count;
            }
            if (!thread.getName().toLowerCase().contains("thrift") || !thread.getName().toLowerCase().contains("pool")) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void cleanup() throws Exception {
    }
}

