/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;

public class CacheTestReader {
    public static void main(String[] args) throws Exception {
        String rootDir = args[0];
        String reportDir = args[1];
        String keepers = args[2];
        int numData = 3;
        File myfile = new File(reportDir + "/" + UUID.randomUUID());
        myfile.deleteOnExit();
        ZooCache zc = new ZooCache(keepers, 30000);
        while (true) {
            List children;
            if (myfile.exists()) {
                myfile.delete();
            }
            if (zc.get(rootDir + "/die") != null) {
                return;
            }
            TreeMap<String, String> readData = new TreeMap<String, String>();
            for (int i = 0; i < numData; ++i) {
                byte[] v = zc.get(rootDir + "/data" + i);
                if (v == null) continue;
                readData.put(rootDir + "/data" + i, new String(v, Constants.UTF8));
            }
            byte[] v = zc.get(rootDir + "/dataS");
            if (v != null) {
                readData.put(rootDir + "/dataS", new String(v, Constants.UTF8));
            }
            if ((children = zc.getChildren(rootDir + "/dir")) != null) {
                for (String child : children) {
                    readData.put(rootDir + "/dir/" + child, "");
                }
            }
            FileOutputStream fos = new FileOutputStream(myfile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(readData);
            fos.close();
            oos.close();
            UtilWaitThread.sleep((long)20L);
        }
    }
}

