/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.CreateRFiles;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BulkSplitOptimizationTest
extends FunctionalTest {
    private static final String TABLE_NAME = "test_ingest";

    @Override
    public void cleanup() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        fs.delete(new Path("tmp/testmf"), true);
        fs.delete(new Path("tmp/testmf_failures"), true);
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return BulkSplitOptimizationTest.parseConfig(Property.TSERV_MAJC_DELAY + "=1s");
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.singletonList(new FunctionalTest.TableSetup(TABLE_NAME, BulkSplitOptimizationTest.parseConfig(Property.TABLE_MAJC_RATIO + "=1000", Property.TABLE_FILE_MAX + "=1000", Property.TABLE_SPLIT_THRESHOLD + "=1G")));
    }

    @Override
    public void run() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        fs.delete(new Path("tmp/testmf"), true);
        AuthenticationToken token = this.getToken();
        CreateRFiles.main(new String[]{"--output", "tmp/testmf", "--numThreads", "8", "--start", "0", "--end", "100000", "--splits", "99"});
        this.bulkImport(fs, TABLE_NAME, "tmp/testmf");
        this.checkSplits(TABLE_NAME, 0, 0);
        this.checkRFiles(TABLE_NAME, 1, 1, 100, 100);
        this.getConnector().tableOperations().setProperty(TABLE_NAME, Property.TABLE_SPLIT_THRESHOLD.getKey(), "100K");
        UtilWaitThread.sleep((long)2000L);
        while (this.getConnector().tableOperations().listSplits(TABLE_NAME).size() < 50) {
            UtilWaitThread.sleep((long)500L);
        }
        this.checkSplits(TABLE_NAME, 50, 100);
        String passwd = "";
        if (token instanceof PasswordToken) {
            passwd = new String(((PasswordToken)token).getPassword(), Constants.UTF8);
        }
        VerifyIngest.main(new String[]{"--timestamp", "1", "--size", "50", "--random", "56", "--rows", "100000", "--start", "0", "--cols", "1", "-p", passwd});
        this.checkRFiles(TABLE_NAME, 50, 100, 1, 4);
    }
}

