/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class BulkFileTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.singletonList(new FunctionalTest.TableSetup("bulkFile", "0333", "0666", "0999", "1333", "1666"));
    }

    @Override
    public void run() throws Exception {
        Configuration conf = new Configuration();
        DefaultConfiguration aconf = ServerConfiguration.getDefaultConfiguration();
        FileSystem fs = TraceFileSystem.wrap((FileSystem)FileUtil.getFileSystem((Configuration)conf, (AccumuloConfiguration)aconf));
        String dir = "/tmp/bulk_test_diff_files_89723987592";
        fs.delete(new Path(dir), true);
        FileSKVWriter writer1 = FileOperations.getInstance().openWriter(dir + "/f1." + "rf", fs, conf, (AccumuloConfiguration)aconf);
        writer1.startDefaultLocalityGroup();
        this.writeData(writer1, 0, 333);
        writer1.close();
        FileSKVWriter writer2 = FileOperations.getInstance().openWriter(dir + "/f2." + "rf", fs, conf, (AccumuloConfiguration)aconf);
        writer2.startDefaultLocalityGroup();
        this.writeData(writer2, 334, 999);
        writer2.close();
        FileSKVWriter writer3 = FileOperations.getInstance().openWriter(dir + "/f3." + "rf", fs, conf, (AccumuloConfiguration)aconf);
        writer3.startDefaultLocalityGroup();
        this.writeData(writer3, 1000, 1999);
        writer3.close();
        this.bulkImport(fs, "bulkFile", dir);
        this.checkRFiles("bulkFile", 6, 6, 1, 1);
        this.verifyData("bulkFile", 0, 1999);
    }

    private void verifyData(String table, int s, int e) throws Exception {
        Scanner scanner = this.getConnector().createScanner(table, Constants.NO_AUTHS);
        Iterator iter = scanner.iterator();
        for (int i = s; i <= e; ++i) {
            if (!iter.hasNext()) {
                throw new Exception("row " + i + " not found");
            }
            Map.Entry entry = (Map.Entry)iter.next();
            String row = String.format("%04d", i);
            if (!((Key)entry.getKey()).getRow().equals((Object)new Text(row))) {
                throw new Exception("unexpected row " + entry.getKey() + " " + i);
            }
            if (Integer.parseInt(((Value)entry.getValue()).toString()) == i) continue;
            throw new Exception("unexpected value " + entry + " " + i);
        }
        if (iter.hasNext()) {
            throw new Exception("found more than expected " + iter.next());
        }
    }

    private void writeData(FileSKVWriter w, int s, int e) throws Exception {
        for (int i = s; i <= e; ++i) {
            w.append(new Key(new Text(String.format("%04d", i))), new Value(Integer.toString(i).getBytes(Constants.UTF8)));
        }
    }
}

