/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class BloomFilterTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        ArrayList<FunctionalTest.TableSetup> tl = new ArrayList<FunctionalTest.TableSetup>();
        tl.add(new FunctionalTest.TableSetup("bt1"));
        tl.add(new FunctionalTest.TableSetup("bt2"));
        tl.add(new FunctionalTest.TableSetup("bt3"));
        tl.add(new FunctionalTest.TableSetup("bt4"));
        return tl;
    }

    @Override
    public void run() throws Exception {
        this.write("bt1", 1, 0L, 1000000000L, 1000);
        this.write("bt2", 2, 0L, 1000000000L, 1000);
        this.write("bt3", 3, 0L, 1000000000L, 1000);
        BatchWriter bw = this.getConnector().createBatchWriter("bt4", new BatchWriterConfig());
        Mutation m = new Mutation(new Text(""));
        m.put(new Text(""), new Text(""), new Value("foo1".getBytes(Constants.UTF8)));
        bw.addMutation(m);
        bw.close();
        this.getConnector().tableOperations().flush("bt4", null, null, true);
        for (String table : new String[]{"bt1", "bt2", "bt3"}) {
            this.getConnector().tableOperations().setProperty(table, Property.TABLE_INDEXCACHE_ENABLED.getKey(), "false");
            this.getConnector().tableOperations().setProperty(table, Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "false");
            this.getConnector().tableOperations().flush(table, null, null, true);
            this.getConnector().tableOperations().compact(table, null, null, false, true);
        }
        super.checkRFiles("bt1", 1, 1, 1, 1);
        super.checkRFiles("bt2", 1, 1, 1, 1);
        super.checkRFiles("bt3", 1, 1, 1, 1);
        super.checkRFiles("bt4", 1, 1, 1, 1);
        long t1 = this.query("bt1", 1, 0L, 1000000000L, 100000, 1000);
        long t2 = this.query("bt2", 2, 0L, 1000000000L, 100000, 1000);
        long t3 = this.query("bt3", 3, 0L, 1000000000L, 100000, 1000);
        this.getConnector().tableOperations().setProperty("bt1", Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.getConnector().tableOperations().setProperty("bt1", Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), "org.apache.accumulo.core.file.keyfunctor.RowFunctor");
        this.getConnector().tableOperations().compact("bt1", null, null, false, true);
        this.getConnector().tableOperations().setProperty("bt2", Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.getConnector().tableOperations().setProperty("bt2", Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), "org.apache.accumulo.core.file.keyfunctor.ColumnFamilyFunctor");
        this.getConnector().tableOperations().compact("bt2", null, null, false, true);
        this.getConnector().tableOperations().setProperty("bt3", Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.getConnector().tableOperations().setProperty("bt3", Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), "org.apache.accumulo.core.file.keyfunctor.ColumnQualifierFunctor");
        this.getConnector().tableOperations().compact("bt3", null, null, false, true);
        this.getConnector().tableOperations().setProperty("bt4", Property.TABLE_BLOOM_ENABLED.getKey(), "true");
        this.getConnector().tableOperations().setProperty("bt4", Property.TABLE_BLOOM_KEY_FUNCTOR.getKey(), "org.apache.accumulo.core.file.keyfunctor.RowFunctor");
        this.getConnector().tableOperations().compact("bt4", null, null, false, true);
        long tb1 = this.query("bt1", 1, 0L, 1000000000L, 100000, 1000);
        long tb2 = this.query("bt2", 2, 0L, 1000000000L, 100000, 1000);
        long tb3 = this.query("bt3", 3, 0L, 1000000000L, 100000, 1000);
        this.timeCheck(t1, tb1);
        this.timeCheck(t2, tb2);
        this.timeCheck(t3, tb3);
        Scanner scanner = this.getConnector().createScanner("bt4", Constants.NO_AUTHS);
        scanner.setRange(new Range(new Text("")));
        if (!((Value)((Map.Entry)scanner.iterator().next()).getValue()).toString().equals("foo1")) {
            throw new Exception("Did not see foo1");
        }
    }

    private void timeCheck(long t1, long t2) throws Exception {
        if ((double)(t1 - t2) * 1.0 / (double)t1 < 0.1) {
            throw new Exception("Queries had less than 10% improvement (old: " + t1 + " new: " + t2 + " improvement: " + (double)(t1 - t2) * 100.0 / (double)t1 + "%)");
        }
    }

    private long query(String table, int depth, long start, long end, int num, int step) throws Exception {
        Random r = new Random(42L);
        HashSet<Long> expected = new HashSet<Long>();
        ArrayList<Range> ranges = new ArrayList<Range>(num);
        Text key = new Text();
        Text row = new Text("row");
        Text cq = new Text("cq");
        Text cf = new Text("cf");
        for (int i = 0; i < num; ++i) {
            Long k = (r.nextLong() & Long.MAX_VALUE) % (end - start) + start;
            key.set(String.format("k_%010d", k));
            Range range = null;
            if (k % (start + (long)step) == 0L) {
                expected.add(k);
            }
            switch (depth) {
                case 1: {
                    range = new Range(new Text(key));
                    break;
                }
                case 2: {
                    Key acuKey = new Key(row, key, cq);
                    range = new Range(acuKey, true, acuKey.followingKey(PartialKey.ROW_COLFAM), false);
                    break;
                }
                case 3: {
                    Key acuKey = new Key(row, cf, key);
                    range = new Range(acuKey, true, acuKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL), false);
                }
            }
            ranges.add(range);
        }
        BatchScanner bs = this.getConnector().createBatchScanner(table, Constants.NO_AUTHS, 3);
        bs.setRanges(ranges);
        long t1 = System.currentTimeMillis();
        for (Map.Entry entry : bs) {
            long v = Long.parseLong(((Value)entry.getValue()).toString());
            if (expected.remove(v)) continue;
            throw new Exception("Got unexpected return " + entry.getKey() + " " + entry.getValue());
        }
        long t2 = System.currentTimeMillis();
        if (expected.size() > 0) {
            throw new Exception("Did not get all expected values " + expected.size());
        }
        bs.close();
        return t2 - t1;
    }

    private void write(String table, int depth, long start, long end, int step) throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter(table, new BatchWriterConfig());
        for (long i = start; i < end; i += (long)step) {
            String key = String.format("k_%010d", i);
            Mutation m = null;
            switch (depth) {
                case 1: {
                    m = new Mutation(new Text(key));
                    m.put(new Text("cf"), new Text("cq"), new Value(Long.toString(i).getBytes(Constants.UTF8)));
                    break;
                }
                case 2: {
                    m = new Mutation(new Text("row"));
                    m.put(new Text(key), new Text("cq"), new Value(Long.toString(i).getBytes(Constants.UTF8)));
                    break;
                }
                case 3: {
                    m = new Mutation(new Text("row"));
                    m.put(new Text("cf"), new Text(key), new Value(Long.toString(i).getBytes(Constants.UTF8)));
                }
            }
            bw.addMutation(m);
        }
        bw.close();
        this.getConnector().tableOperations().flush(table, null, null, true);
    }
}

