/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class BatchScanSplitTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put(Property.TSERV_MAJC_DELAY.getKey(), "0");
        return conf;
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.singletonList(new FunctionalTest.TableSetup("bss"));
    }

    @Override
    public void run() throws Exception {
        int numRows = 262144;
        BatchWriter bw = this.getConnector().createBatchWriter("bss", new BatchWriterConfig());
        for (int i = 0; i < numRows; ++i) {
            Mutation m = new Mutation(new Text(String.format("%09x", i)));
            m.put(new Text("cf1"), new Text("cq1"), new Value(String.format("%016x", numRows - i).getBytes(Constants.UTF8)));
            bw.addMutation(m);
        }
        bw.close();
        this.getConnector().tableOperations().flush("bss", null, null, true);
        this.getConnector().tableOperations().setProperty("bss", Property.TABLE_SPLIT_THRESHOLD.getKey(), "4K");
        Collection splits = this.getConnector().tableOperations().listSplits("bss");
        while (splits.size() < 2) {
            UtilWaitThread.sleep((long)1L);
            splits = this.getConnector().tableOperations().listSplits("bss");
        }
        System.out.println("splits : " + splits);
        Random random = new Random(19011230L);
        HashMap<Text, Value> expected = new HashMap<Text, Value>();
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < 100; ++i) {
            int r = random.nextInt(numRows);
            Text row = new Text(String.format("%09x", r));
            expected.put(row, new Value(String.format("%016x", numRows - r).getBytes(Constants.UTF8)));
            ranges.add(new Range(row));
        }
        BatchScanner bs = this.getConnector().createBatchScanner("bss", Constants.NO_AUTHS, 4);
        HashMap found = new HashMap();
        for (int i = 0; i < 20; ++i) {
            found.clear();
            long t1 = System.currentTimeMillis();
            bs.setRanges(ranges);
            for (Map.Entry entry : bs) {
                found.put(((Key)entry.getKey()).getRow(), entry.getValue());
            }
            long t2 = System.currentTimeMillis();
            System.out.printf("rate : %06.2f%n", (double)ranges.size() / ((double)(t2 - t1) / 1000.0));
            if (found.equals(expected)) continue;
            throw new Exception("Found and expected differ " + found + " " + expected);
        }
        splits = this.getConnector().tableOperations().listSplits("bss");
        System.out.println("splits : " + splits);
    }
}

