/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.BadIterator;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class BadIteratorMincTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        String pre = Property.TABLE_ITERATOR_PREFIX.getKey();
        FunctionalTest.TableSetup ts = new FunctionalTest.TableSetup("foo", BadIteratorMincTest.parseConfig(pre + "minc.badi=30," + BadIterator.class.getName()));
        return Collections.singletonList(ts);
    }

    @Override
    public void run() throws Exception {
        BatchWriter bw = this.getConnector().createBatchWriter("foo", new BatchWriterConfig());
        Mutation m = new Mutation(new Text("r1"));
        m.put(new Text("acf"), new Text("foo"), new Value("1".getBytes(Constants.UTF8)));
        bw.addMutation(m);
        bw.close();
        this.getConnector().tableOperations().flush("foo", null, null, false);
        UtilWaitThread.sleep((long)1000L);
        this.checkRFiles("foo", 1, 1, 0, 0);
        Scanner scanner = this.getConnector().createScanner("foo", Constants.NO_AUTHS);
        int count = 0;
        for (Map.Entry entry : scanner) {
            ++count;
        }
        if (count != 1) {
            throw new Exception("Did not see expected # entries " + count);
        }
        this.getConnector().tableOperations().removeProperty("foo", Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.badi");
        UtilWaitThread.sleep((long)5000L);
        this.checkRFiles("foo", 1, 1, 1, 1);
        count = 0;
        for (Map.Entry entry : scanner) {
            ++count;
        }
        if (count != 1) {
            throw new Exception("Did not see expected # entries " + count);
        }
        this.getConnector().tableOperations().setProperty("foo", Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.badi", "30," + BadIterator.class.getName());
        bw = this.getConnector().createBatchWriter("foo", new BatchWriterConfig());
        m = new Mutation(new Text("r2"));
        m.put(new Text("acf"), new Text("foo"), new Value("1".getBytes(Constants.UTF8)));
        bw.addMutation(m);
        bw.close();
        UtilWaitThread.sleep((long)1000L);
        this.getConnector().tableOperations().flush("foo", null, null, false);
        UtilWaitThread.sleep((long)1000L);
        this.getConnector().tableOperations().delete("foo");
    }
}

