/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.functional.FunctionalTest;
import org.apache.hadoop.io.Text;

public class AddSplitTest
extends FunctionalTest {
    @Override
    public void cleanup() throws Exception {
    }

    @Override
    public Map<String, String> getInitialConfig() {
        return Collections.emptyMap();
    }

    @Override
    public List<FunctionalTest.TableSetup> getTablesToCreate() {
        return Collections.singletonList(new FunctionalTest.TableSetup("foo"));
    }

    @Override
    public void run() throws Exception {
        this.insertData(1L);
        TreeSet<Text> splits = new TreeSet<Text>();
        splits.add(new Text(String.format("%09d", 333)));
        splits.add(new Text(String.format("%09d", 666)));
        this.getConnector().tableOperations().addSplits("foo", splits);
        UtilWaitThread.sleep((long)100L);
        Collection actualSplits = this.getConnector().tableOperations().listSplits("foo");
        if (!splits.equals(new TreeSet(actualSplits))) {
            throw new Exception(splits + " != " + actualSplits);
        }
        this.verifyData(1L);
        this.insertData(2L);
        splits.add(new Text(String.format("%09d", 200)));
        splits.add(new Text(String.format("%09d", 500)));
        splits.add(new Text(String.format("%09d", 800)));
        this.getConnector().tableOperations().addSplits("foo", splits);
        UtilWaitThread.sleep((long)100L);
        actualSplits = this.getConnector().tableOperations().listSplits("foo");
        if (!splits.equals(new TreeSet(actualSplits))) {
            throw new Exception(splits + " != " + actualSplits);
        }
        this.verifyData(2L);
    }

    private void verifyData(long ts) throws Exception {
        Scanner scanner = this.getConnector().createScanner("foo", Constants.NO_AUTHS);
        Iterator iter = scanner.iterator();
        for (int i = 0; i < 10000; ++i) {
            if (!iter.hasNext()) {
                throw new Exception("row " + i + " not found");
            }
            Map.Entry entry = (Map.Entry)iter.next();
            String row = String.format("%09d", i);
            if (!((Key)entry.getKey()).getRow().equals((Object)new Text(row))) {
                throw new Exception("unexpected row " + entry.getKey() + " " + i);
            }
            if (((Key)entry.getKey()).getTimestamp() != ts) {
                throw new Exception("unexpected ts " + entry.getKey() + " " + ts);
            }
            if (Integer.parseInt(((Value)entry.getValue()).toString()) == i) continue;
            throw new Exception("unexpected value " + entry + " " + i);
        }
        if (iter.hasNext()) {
            throw new Exception("found more than expected " + iter.next());
        }
    }

    private void insertData(long ts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException {
        BatchWriter bw = this.getConnector().createBatchWriter("foo", new BatchWriterConfig());
        for (int i = 0; i < 10000; ++i) {
            String row = String.format("%09d", i);
            Mutation m = new Mutation(new Text(row));
            m.put(new Text("cf1"), new Text("cq1"), ts, new Value(Integer.toString(i).getBytes(Constants.UTF8)));
            bw.addMutation(m);
        }
        bw.close();
    }
}

