/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.ColumnFamilyCounter;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.cli.ClientOnRequiredTable;
import org.apache.accumulo.server.monitor.Monitor;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class ContinuousStatsCollector {
    private static String getMRStats() throws Exception {
        Configuration conf = CachedConfiguration.getInstance();
        JobClient jc = new JobClient(new JobConf(conf));
        ClusterStatus cs = jc.getClusterStatus(false);
        return "" + cs.getMapTasks() + " " + cs.getMaxMapTasks() + " " + cs.getReduceTasks() + " " + cs.getMaxReduceTasks() + " " + cs.getTaskTrackers() + " " + cs.getBlacklistedTrackers();
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(ContinuousStatsCollector.class.getName(), args, new Object[]{scanOpts});
        Timer jtimer = new Timer();
        jtimer.schedule((TimerTask)new StatsCollectionTask(opts, scanOpts.scanBatchSize), 0L, 30000L);
    }

    static class Opts
    extends ClientOnRequiredTable {
        Opts() {
        }
    }

    static class StatsCollectionTask
    extends TimerTask {
        private final String tableId;
        private final Opts opts;
        private final int scanBatchSize;

        public StatsCollectionTask(Opts opts, int scanBatchSize) {
            this.opts = opts;
            this.scanBatchSize = scanBatchSize;
            this.tableId = (String)Tables.getNameToIdMap((Instance)opts.getInstance()).get(opts.tableName);
            System.out.println("TIME TABLET_SERVERS TOTAL_ENTRIES TOTAL_INGEST TOTAL_QUERY TABLE_RECS TABLE_RECS_IN_MEM TABLE_INGEST TABLE_QUERY TABLE_TABLETS TABLE_TABLETS_ONLINE ACCUMULO_DU ACCUMULO_DIRS ACCUMULO_FILES TABLE_DU TABLE_DIRS TABLE_FILES MAP_TASK MAX_MAP_TASK REDUCE_TASK MAX_REDUCE_TASK TASK_TRACKERS BLACK_LISTED MIN_FILES/TABLET MAX_FILES/TABLET AVG_FILES/TABLET STDDEV_FILES/TABLET");
        }

        @Override
        public void run() {
            try {
                String acuStats = this.getACUStats();
                String fsStats = this.getFSStats();
                String mrStats = ContinuousStatsCollector.getMRStats();
                String tabletStats = this.getTabletStats();
                System.out.println(System.currentTimeMillis() + " " + acuStats + " " + fsStats + " " + mrStats + " " + tabletStats);
            }
            catch (Exception e) {
                System.err.println(System.currentTimeMillis() + " Failed to collect stats : " + e.getMessage());
                e.printStackTrace();
            }
        }

        private String getTabletStats() throws Exception {
            Connector conn = this.opts.getConnector();
            Scanner scanner = conn.createScanner("!METADATA", this.opts.auths);
            scanner.setBatchSize(this.scanBatchSize);
            scanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
            scanner.addScanIterator(new IteratorSetting(1000, "cfc", ColumnFamilyCounter.class.getName()));
            scanner.setRange(new KeyExtent(new Text(this.tableId), null, null).toMetadataRange());
            Stat s = new Stat();
            int count = 0;
            for (Map.Entry entry : scanner) {
                ++count;
                s.addStat(Long.parseLong(((Value)entry.getValue()).toString()));
            }
            if (count > 0) {
                return String.format("%d %d %.3f %.3f", s.getMin(), s.getMax(), s.getAverage(), s.getStdDev());
            }
            return "0 0 0 0";
        }

        private String getFSStats() throws Exception {
            FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
            Path acudir = new Path(ServerConstants.getTablesDir());
            ContentSummary contentSummary = fs.getContentSummary(acudir);
            Path tableDir = new Path(ServerConstants.getTablesDir() + "/" + this.tableId);
            ContentSummary contentSummary2 = fs.getContentSummary(tableDir);
            return "" + contentSummary.getLength() + " " + contentSummary.getDirectoryCount() + " " + contentSummary.getFileCount() + " " + contentSummary2.getLength() + " " + contentSummary2.getDirectoryCount() + " " + contentSummary2.getFileCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getACUStats() throws Exception {
            MasterClientService.Client client = null;
            try {
                client = MasterClient.getConnectionWithRetry((Instance)this.opts.getInstance());
                MasterMonitorInfo stats = client.getMasterStats(Tracer.traceInfo(), SecurityConstants.getSystemCredentials());
                TableInfo all = new TableInfo();
                HashMap tableSummaries = new HashMap();
                for (TabletServerStatus server : stats.tServerInfo) {
                    for (Map.Entry info : server.tableMap.entrySet()) {
                        TableInfo tableSummary = (TableInfo)tableSummaries.get(info.getKey());
                        if (tableSummary == null) {
                            tableSummary = new TableInfo();
                            tableSummaries.put(info.getKey(), tableSummary);
                        }
                        Monitor.add((TableInfo)tableSummary, (TableInfo)((TableInfo)info.getValue()));
                        Monitor.add((TableInfo)all, (TableInfo)((TableInfo)info.getValue()));
                    }
                }
                TableInfo ti = (TableInfo)tableSummaries.get(this.tableId);
                String string = "" + stats.tServerInfo.size() + " " + all.recs + " " + (long)all.ingestRate + " " + (long)all.queryRate + " " + ti.recs + " " + ti.recsInMemory + " " + (long)ti.ingestRate + " " + (long)ti.queryRate + " " + ti.tablets + " " + ti.onlineTablets;
                return string;
            }
            finally {
                if (client != null) {
                    MasterClient.close((MasterClientService.Iface)client);
                }
            }
        }
    }
}

