/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.trace.instrument.CountSampler;
import org.apache.accumulo.trace.instrument.Sampler;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class ContinuousIngest {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static List<ColumnVisibility> visibilities;

    private static void initVisibilities(Opts opts) throws Exception {
        String line;
        if (opts.visFile == null) {
            visibilities = Collections.singletonList(new ColumnVisibility());
            return;
        }
        visibilities = new ArrayList<ColumnVisibility>();
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(opts.visFile)), Constants.UTF8));
        while ((line = in.readLine()) != null) {
            visibilities.add(new ColumnVisibility(line));
        }
        in.close();
    }

    private static ColumnVisibility getVisibility(Random rand) {
        return visibilities.get(rand.nextInt(visibilities.size()));
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(ContinuousIngest.class.getName(), args, new Object[]{bwOpts});
        ContinuousIngest.initVisibilities(opts);
        if (opts.min < 0L || opts.max < 0L || opts.max <= opts.min) {
            throw new IllegalArgumentException("bad min and max");
        }
        Connector conn = opts.getConnector();
        if (!conn.tableOperations().exists(opts.getTableName())) {
            try {
                conn.tableOperations().create(opts.getTableName());
            }
            catch (TableExistsException tee) {
                // empty catch block
            }
        }
        BatchWriter bw = conn.createBatchWriter(opts.getTableName(), bwOpts.getBatchWriterConfig());
        bw = (BatchWriter)Trace.wrapAll((Object)bw, (Sampler)new CountSampler(1024L));
        Random r = new Random();
        byte[] ingestInstanceId = UUID.randomUUID().toString().getBytes(Constants.UTF8);
        System.out.printf("UUID %d %s%n", System.currentTimeMillis(), new String(ingestInstanceId, Constants.UTF8));
        long count = 0L;
        int flushInterval = 1000000;
        int maxDepth = 25;
        long[] prevRows = new long[1000000];
        long[] firstRows = new long[1000000];
        int[] firstColFams = new int[1000000];
        int[] firstColQuals = new int[1000000];
        long lastFlushTime = System.currentTimeMillis();
        block2: do {
            Mutation m;
            int index;
            ColumnVisibility cv = ContinuousIngest.getVisibility(r);
            for (index = 0; index < 1000000; ++index) {
                long rowLong;
                prevRows[index] = rowLong = ContinuousIngest.genLong(opts.min, opts.max, r);
                firstRows[index] = rowLong;
                int cf = r.nextInt(opts.maxColF);
                int cq = r.nextInt(opts.maxColQ);
                firstColFams[index] = cf;
                firstColQuals[index] = cq;
                m = ContinuousIngest.genMutation(rowLong, cf, cq, cv, ingestInstanceId, count, null, r, opts.checksum);
                ++count;
                bw.addMutation(m);
            }
            lastFlushTime = ContinuousIngest.flush(bw, count, 1000000, lastFlushTime);
            if (count >= opts.num) break;
            for (int depth = 1; depth < 25; ++depth) {
                for (int index2 = 0; index2 < 1000000; ++index2) {
                    long rowLong = ContinuousIngest.genLong(opts.min, opts.max, r);
                    byte[] prevRow = ContinuousIngest.genRow(prevRows[index2]);
                    prevRows[index2] = rowLong;
                    m = ContinuousIngest.genMutation(rowLong, r.nextInt(opts.maxColF), r.nextInt(opts.maxColQ), cv, ingestInstanceId, count, prevRow, r, opts.checksum);
                    ++count;
                    bw.addMutation(m);
                }
                lastFlushTime = ContinuousIngest.flush(bw, count, 1000000, lastFlushTime);
                if (count < opts.num) {
                    continue;
                }
                break block2;
            }
            for (index = 0; index < 999999; ++index) {
                Mutation m2 = ContinuousIngest.genMutation(firstRows[index], firstColFams[index], firstColQuals[index], cv, ingestInstanceId, count, ContinuousIngest.genRow(prevRows[index + 1]), r, opts.checksum);
                ++count;
                bw.addMutation(m2);
            }
            lastFlushTime = ContinuousIngest.flush(bw, count, 1000000, lastFlushTime);
        } while (count < opts.num);
        bw.close();
        opts.stopTracing();
    }

    private static long flush(BatchWriter bw, long count, int flushInterval, long lastFlushTime) throws MutationsRejectedException {
        long t1 = System.currentTimeMillis();
        bw.flush();
        long t2 = System.currentTimeMillis();
        System.out.printf("FLUSH %d %d %d %d %d%n", t2, t2 - lastFlushTime, t2 - t1, count, flushInterval);
        lastFlushTime = t2;
        return lastFlushTime;
    }

    public static Mutation genMutation(long rowLong, int cfInt, int cqInt, ColumnVisibility cv, byte[] ingestInstanceId, long count, byte[] prevRow, Random r, boolean checksum) {
        CRC32 cksum = null;
        byte[] rowString = ContinuousIngest.genRow(rowLong);
        byte[] cfString = FastFormat.toZeroPaddedString((long)cfInt, (int)4, (int)16, (byte[])EMPTY_BYTES);
        byte[] cqString = FastFormat.toZeroPaddedString((long)cqInt, (int)4, (int)16, (byte[])EMPTY_BYTES);
        if (checksum) {
            cksum = new CRC32();
            cksum.update(rowString);
            cksum.update(cfString);
            cksum.update(cqString);
            cksum.update(cv.getExpression());
        }
        Mutation m = new Mutation(new Text(rowString));
        m.put(new Text(cfString), new Text(cqString), cv, ContinuousIngest.createValue(ingestInstanceId, count, prevRow, cksum));
        return m;
    }

    public static final long genLong(long min, long max, Random r) {
        return (r.nextLong() & Long.MAX_VALUE) % (max - min) + min;
    }

    static final byte[] genRow(long min, long max, Random r) {
        return ContinuousIngest.genRow(ContinuousIngest.genLong(min, max, r));
    }

    static final byte[] genRow(long rowLong) {
        return FastFormat.toZeroPaddedString((long)rowLong, (int)16, (int)16, (byte[])EMPTY_BYTES);
    }

    private static Value createValue(byte[] ingestInstanceId, long count, byte[] prevRow, Checksum cksum) {
        int dataLen = ingestInstanceId.length + 16 + (prevRow == null ? 0 : prevRow.length) + 3;
        if (cksum != null) {
            dataLen += 8;
        }
        byte[] val = new byte[dataLen];
        System.arraycopy(ingestInstanceId, 0, val, 0, ingestInstanceId.length);
        int index = ingestInstanceId.length;
        val[index++] = 58;
        int added = FastFormat.toZeroPaddedString((byte[])val, (int)index, (long)count, (int)16, (int)16, (byte[])EMPTY_BYTES);
        if (added != 16) {
            throw new RuntimeException(" " + added);
        }
        index += 16;
        val[index++] = 58;
        if (prevRow != null) {
            System.arraycopy(prevRow, 0, val, index, prevRow.length);
            index += prevRow.length;
        }
        val[index++] = 58;
        if (cksum != null) {
            cksum.update(val, 0, index);
            cksum.getValue();
            FastFormat.toZeroPaddedString((byte[])val, (int)index, (long)cksum.getValue(), (int)8, (int)16, (byte[])EMPTY_BYTES);
        }
        return new Value(val);
    }

    public static class Opts
    extends BaseOpts {
        @Parameter(names={"--num"}, description="the number of entries to ingest")
        long num = Long.MAX_VALUE;
        @Parameter(names={"--maxColF"}, description="maximum column family value to use", converter=ShortConverter.class)
        short maxColF = Short.MAX_VALUE;
        @Parameter(names={"--maxColQ"}, description="maximum column qualifier value to use", converter=ShortConverter.class)
        short maxColQ = Short.MAX_VALUE;
        @Parameter(names={"--addCheckSum"}, description="turn on checksums")
        boolean checksum = false;
        @Parameter(names={"--visibilities"}, description="read the visibilities to ingest with from a file")
        String visFile = null;
    }

    public static class ShortConverter
    implements IStringConverter<Short> {
        public Short convert(String value) {
            return Short.valueOf(value);
        }
    }

    public static class BaseOpts
    extends ClientOnDefaultTable {
        @Parameter(names={"--min"}, description="lowest random row number to use")
        long min = 0L;
        @Parameter(names={"--max"}, description="maximum random row number to use")
        long max = Long.MAX_VALUE;
        @Parameter(names={"--debugLog"}, description="file to write debugging output", converter=DebugConverter.class)
        String debugLog = null;

        BaseOpts() {
            super("ci");
        }

        public class DebugConverter
        implements IStringConverter<String> {
            public String convert(String debugLog) {
                Logger logger = Logger.getLogger((String)"org.apache.accumulo.core");
                logger.setLevel(Level.TRACE);
                logger.setAdditivity(false);
                try {
                    logger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%d{dd HH:mm:ss,SSS} [%-8c{2}] %-5p: %m%n"), debugLog, true));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return debugLog;
            }
        }
    }
}

