/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.BatchScannerOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.accumulo.test.continuous.ContinuousWalk;
import org.apache.hadoop.io.Text;

public class ContinuousBatchWalker {
    private static HashSet<Text> rowsToQuery = new HashSet();

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        BatchScannerOpts bsOpts = new BatchScannerOpts();
        opts.parseArgs(ContinuousBatchWalker.class.getName(), args, new Object[]{scanOpts, bsOpts});
        Random r = new Random();
        Authorizations auths = opts.randomAuths.getAuths(r);
        Connector conn = opts.getConnector();
        Scanner scanner = conn.createScanner(opts.getTableName(), auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        BatchScanner bs = conn.createBatchScanner(opts.getTableName(), auths, bsOpts.scanThreads.intValue());
        bs.setTimeout(bsOpts.scanTimeout.longValue(), TimeUnit.MILLISECONDS);
        while (true) {
            Set<Text> batch = ContinuousBatchWalker.getBatch(scanner, opts.min, opts.max, scanOpts.scanBatchSize, r);
            ArrayList<Range> ranges = new ArrayList<Range>(batch.size());
            for (Text row : batch) {
                ranges.add(new Range(row));
            }
            ContinuousBatchWalker.runBatchScan(scanOpts.scanBatchSize, bs, batch, ranges);
            UtilWaitThread.sleep((long)opts.sleepTime);
        }
    }

    private static void runBatchScan(int batchSize, BatchScanner bs, Set<Text> batch, List<Range> ranges) {
        bs.setRanges(ranges);
        HashSet<Text> rowsSeen = new HashSet<Text>();
        int count = 0;
        long t1 = System.currentTimeMillis();
        for (Map.Entry entry : bs) {
            ContinuousWalk.validate((Key)entry.getKey(), (Value)entry.getValue());
            rowsSeen.add(((Key)entry.getKey()).getRow());
            ContinuousBatchWalker.addRow(batchSize, (Value)entry.getValue());
            ++count;
        }
        long t2 = System.currentTimeMillis();
        if (!((Object)rowsSeen).equals(batch)) {
            HashSet copy1 = new HashSet(rowsSeen);
            HashSet<Text> copy2 = new HashSet<Text>(batch);
            copy1.removeAll(batch);
            copy2.removeAll(rowsSeen);
            System.out.printf("DIF %d %d %d%n", t1, copy1.size(), copy2.size());
            System.err.printf("DIF %d %d %d%n", t1, copy1.size(), copy2.size());
            System.err.println("Extra seen : " + copy1);
            System.err.println("Not seen   : " + copy2);
        } else {
            System.out.printf("BRQ %d %d %d %d %d%n", t1, t2 - t1, rowsSeen.size(), count, (int)((double)rowsSeen.size() / ((double)(t2 - t1) / 1000.0)));
        }
    }

    private static void addRow(int batchSize, Value v) {
        byte[] val = v.get();
        int offset = ContinuousWalk.getPrevRowOffset(val);
        if (offset > 1) {
            Text prevRow = new Text();
            prevRow.set(val, offset, 16);
            if (rowsToQuery.size() < 3 * batchSize) {
                rowsToQuery.add(prevRow);
            }
        }
    }

    private static Set<Text> getBatch(Scanner scanner, long min, long max, int batchSize, Random r) {
        while (rowsToQuery.size() < batchSize) {
            byte[] scanStart = ContinuousIngest.genRow(min, max, r);
            scanner.setRange(new Range(new Text(scanStart), null));
            int count = 0;
            long t1 = System.currentTimeMillis();
            Iterator iter = scanner.iterator();
            while (iter.hasNext() && rowsToQuery.size() < 3 * batchSize) {
                Map.Entry entry = (Map.Entry)iter.next();
                ContinuousWalk.validate((Key)entry.getKey(), (Value)entry.getValue());
                ContinuousBatchWalker.addRow(batchSize, (Value)entry.getValue());
                ++count;
            }
            long t2 = System.currentTimeMillis();
            System.out.println("FSB " + t1 + " " + (t2 - t1) + " " + count);
            UtilWaitThread.sleep((long)100L);
        }
        HashSet<Text> ret = new HashSet<Text>();
        Iterator<Text> iter = rowsToQuery.iterator();
        for (int i = 0; i < batchSize; ++i) {
            ret.add(iter.next());
            iter.remove();
        }
        return ret;
    }

    static class Opts
    extends ContinuousWalk.Opts {
        @Parameter(names={"--numToScan"}, description="Number rows to scan between sleeps", required=true, validateWith=PositiveInteger.class)
        long numToScan = 0L;

        Opts() {
        }
    }
}

