/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class VerifyIngest {
    private static final Logger log = Logger.getLogger(VerifyIngest.class);

    public static int getRow(Key k) {
        return Integer.parseInt(k.getRow().toString().split("_")[1]);
    }

    public static int getCol(Key k) {
        return Integer.parseInt(k.getColumnQualifier().toString().split("_")[1]);
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(VerifyIngest.class.getName(), args, new Object[]{scanOpts});
        Instance instance = opts.getInstance();
        try {
            if (opts.trace) {
                String name = VerifyIngest.class.getSimpleName();
                DistributedTrace.enable((Instance)instance, (ZooReader)new ZooReader(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut()), (String)name, null);
                Trace.on((String)name);
                Trace.currentTrace().data("cmdLine", Arrays.asList(args).toString());
            }
            Connector connector = opts.getConnector();
            byte[][] bytevals = TestIngest.generateValues(opts);
            Authorizations labelAuths = new Authorizations(new String[]{"L1", "L2", "G1", "GROUP2"});
            connector.securityOperations().changeUserAuthorizations(opts.principal, labelAuths);
            int expectedRow = opts.startRow;
            int expectedCol = 0;
            int recsRead = 0;
            long bytesRead = 0L;
            long t1 = System.currentTimeMillis();
            byte[] randomValue = new byte[opts.dataSize];
            Random random = new Random();
            Key endKey = new Key(new Text("row_" + String.format("%010d", opts.rows + opts.startRow)));
            int errors = 0;
            while (expectedRow < opts.rows + opts.startRow) {
                if (opts.useGet) {
                    Text rowKey = new Text("row_" + String.format("%010d", expectedRow + opts.startRow));
                    Text colf = new Text(opts.columnFamily);
                    Text colq = new Text("col_" + String.format("%07d", expectedCol));
                    Scanner scanner = connector.createScanner("test_ingest", labelAuths);
                    scanner.setBatchSize(1);
                    Key startKey = new Key(rowKey, colf, colq);
                    Range range = new Range(startKey, startKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL));
                    scanner.setRange(range);
                    byte[] val = null;
                    Iterator iter = scanner.iterator();
                    if (iter.hasNext()) {
                        val = ((Value)((Map.Entry)iter.next()).getValue()).get();
                    }
                    byte[] ev = opts.random != null ? TestIngest.genRandomValue(random, randomValue, opts.random, expectedRow, expectedCol) : bytevals[expectedCol % bytevals.length];
                    if (val == null) {
                        log.error((Object)("Did not find " + rowKey + " " + colf + " " + colq));
                        ++errors;
                    } else {
                        ++recsRead;
                        bytesRead += (long)val.length;
                        Value value = new Value(val);
                        if (value.compareTo(ev) != 0) {
                            log.error((Object)("unexpected value  (" + rowKey + " " + colf + " " + colq + " : saw " + value + " expected " + new Value(ev)));
                            ++errors;
                        }
                    }
                    if (++expectedCol < opts.cols) continue;
                    expectedCol = 0;
                    ++expectedRow;
                    continue;
                }
                Key startKey = new Key(new Text("row_" + String.format("%010d", expectedRow)));
                Scanner scanner = connector.createScanner("test_ingest", labelAuths);
                scanner.setBatchSize(scanOpts.scanBatchSize);
                scanner.setRange(new Range(startKey, endKey));
                for (int j = 0; j < opts.cols; ++j) {
                    scanner.fetchColumn(new Text(opts.columnFamily), new Text("col_" + String.format("%07d", j)));
                }
                int recsReadBefore = recsRead;
                for (Map.Entry entry : scanner) {
                    ++recsRead;
                    bytesRead += (long)((Key)entry.getKey()).getLength();
                    bytesRead += (long)((Value)entry.getValue()).getSize();
                    int rowNum = VerifyIngest.getRow((Key)entry.getKey());
                    int colNum = VerifyIngest.getCol((Key)entry.getKey());
                    if (rowNum != expectedRow) {
                        log.error((Object)("rowNum != expectedRow   " + rowNum + " != " + expectedRow));
                        ++errors;
                        expectedRow = rowNum;
                    }
                    if (colNum != expectedCol) {
                        log.error((Object)("colNum != expectedCol  " + colNum + " != " + expectedCol + "  rowNum : " + rowNum));
                        ++errors;
                    }
                    if (expectedRow >= opts.rows + opts.startRow) {
                        log.error((Object)("expectedRow (" + expectedRow + ") >= (ingestArgs.rows + ingestArgs.startRow)  (" + (opts.rows + opts.startRow) + "), get batch returned data passed end key"));
                        ++errors;
                        break;
                    }
                    byte[] value = opts.random != null ? TestIngest.genRandomValue(random, randomValue, opts.random, expectedRow, colNum) : bytevals[colNum % bytevals.length];
                    if (((Value)entry.getValue()).compareTo(value) != 0) {
                        log.error((Object)("unexpected value, rowNum : " + rowNum + " colNum : " + colNum));
                        log.error((Object)(" saw = " + new String(((Value)entry.getValue()).get()) + " expected = " + new String(value, Constants.UTF8)));
                        ++errors;
                    }
                    if (opts.timestamp >= 0L && ((Key)entry.getKey()).getTimestamp() != opts.timestamp) {
                        log.error((Object)("unexpected timestamp " + ((Key)entry.getKey()).getTimestamp() + ", rowNum : " + rowNum + " colNum : " + colNum));
                        ++errors;
                    }
                    if (++expectedCol < opts.cols) continue;
                    expectedCol = 0;
                    ++expectedRow;
                }
                if (recsRead != recsReadBefore) continue;
                log.warn((Object)"Scan returned nothing, breaking...");
                break;
            }
            long t2 = System.currentTimeMillis();
            if (errors > 0) {
                log.error((Object)("saw " + errors + " errors "));
                System.exit(1);
            }
            if (expectedRow != opts.rows + opts.startRow) {
                log.error((Object)("Did not read expected number of rows. Saw " + (expectedRow - opts.startRow) + " expected " + opts.rows));
                System.exit(1);
            } else {
                System.out.printf("%,12d records read | %,8d records/sec | %,12d bytes read | %,8d bytes/sec | %6.3f secs   %n", recsRead, (int)((double)recsRead / ((double)(t2 - t1) / 1000.0)), bytesRead, (int)((double)bytesRead / ((double)(t2 - t1) / 1000.0)), (double)(t2 - t1) / 1000.0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Trace.off();
        }
    }

    public static class Opts
    extends TestIngest.Opts {
        @Parameter(names={"-useGet"}, description="fetches values one at a time, instead of scanning")
        boolean useGet = false;
    }
}

