/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class TestRandomDeletes {
    private static final Logger log = Logger.getLogger(TestRandomDeletes.class);
    private static Authorizations auths = new Authorizations(new String[]{"L1", "L2", "G1", "GROUP2"});

    private static TreeSet<RowColumn> scanAll(ClientOpts opts, ScannerOpts scanOpts, Text t) throws Exception {
        TreeSet<RowColumn> result = new TreeSet<RowColumn>();
        Connector conn = opts.getConnector();
        Scanner scanner = conn.createScanner(t.toString(), auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        for (Map.Entry entry : scanner) {
            Key key = (Key)entry.getKey();
            Column column = new Column(TextUtil.getBytes((Text)key.getColumnFamily()), TextUtil.getBytes((Text)key.getColumnQualifier()), TextUtil.getBytes((Text)key.getColumnVisibility()));
            result.add(new RowColumn(key.getRow(), column, key.getTimestamp()));
        }
        return result;
    }

    private static long scrambleDeleteHalfAndCheck(ClientOpts opts, ScannerOpts scanOpts, BatchWriterOpts bwOpts, Text t, Set<RowColumn> rows) throws Exception {
        int result = 0;
        ArrayList<RowColumn> entries = new ArrayList<RowColumn>(rows);
        Collections.shuffle(entries);
        Connector connector = opts.getConnector();
        BatchWriter mutations = connector.createBatchWriter(t.toString(), bwOpts.getBatchWriterConfig());
        for (int i = 0; i < (entries.size() + 1) / 2; ++i) {
            RowColumn rc = entries.get(i);
            Mutation m = new Mutation(rc.row);
            m.putDelete(new Text(rc.column.columnFamily), new Text(rc.column.columnQualifier), new ColumnVisibility(rc.column.getColumnVisibility()), rc.timestamp + 1L);
            mutations.addMutation(m);
            rows.remove(rc);
            ++result;
        }
        mutations.close();
        TreeSet<RowColumn> current = TestRandomDeletes.scanAll(opts, scanOpts, t);
        current.removeAll(rows);
        if (current.size() > 0) {
            throw new RuntimeException(current.size() + " records not deleted");
        }
        return result;
    }

    public static void main(String[] args) {
        ClientOpts opts = new ClientOpts();
        ScannerOpts scanOpts = new ScannerOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(TestRandomDeletes.class.getName(), args, new Object[]{scanOpts, bwOpts});
        try {
            long half;
            long deleted = 0L;
            Text t = new Text("test_ingest");
            TreeSet<RowColumn> doomed = TestRandomDeletes.scanAll(opts, scanOpts, t);
            log.info((Object)("Got " + doomed.size() + " rows"));
            long startTime = System.currentTimeMillis();
            do {
                half = TestRandomDeletes.scrambleDeleteHalfAndCheck(opts, scanOpts, bwOpts, t, doomed);
                deleted += half;
            } while (half != 0L);
            long stopTime = System.currentTimeMillis();
            long elapsed = (stopTime - startTime) / 1000L;
            log.info((Object)("deleted " + deleted + " values in " + elapsed + " seconds"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RowColumn
    implements Comparable<RowColumn> {
        Text row;
        Column column;
        long timestamp;

        public RowColumn(Text row, Column column, long timestamp) {
            this.row = row;
            this.column = column;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(RowColumn other) {
            int result = this.row.compareTo((BinaryComparable)other.row);
            if (result != 0) {
                return result;
            }
            return this.column.compareTo(other.column);
        }

        public String toString() {
            return this.row.toString() + ":" + this.column.toString();
        }
    }
}

