/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.server.cli.ClientOnRequiredTable;
import org.apache.hadoop.io.Text;

public class TestBinaryRows {
    private static final long byteOnes;

    static byte[] encodeLong(long l) {
        byte[] ba = new byte[8];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)(byteOnes & l >>> 8 * (ba.length - i - 1));
        }
        return ba;
    }

    static long decodeLong(byte[] ba) {
        if (ba.length > 8) {
            throw new IllegalArgumentException("Byte array of size " + ba.length + " is too big to hold a long");
        }
        long l = 0L;
        for (int i = 0; i < ba.length; ++i) {
            l |= (byteOnes & (long)ba[i]) << 8 * (ba.length - i - 1);
        }
        return l;
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(TestBinaryRows.class.getName(), args, new Object[]{scanOpts, bwOpts});
        try {
            Connector connector = opts.getConnector();
            Text CF = new Text("cf");
            Text CQ = new Text("cq");
            byte[] CF_BYTES = "cf".getBytes(Constants.UTF8);
            byte[] CQ_BYTES = "cq".getBytes(Constants.UTF8);
            if (opts.mode.equals("ingest") || opts.mode.equals("delete")) {
                BatchWriter bw = connector.createBatchWriter(opts.tableName, bwOpts.getBatchWriterConfig());
                boolean delete = opts.mode.equals("delete");
                for (long i = 0L; i < opts.num; ++i) {
                    byte[] row = TestBinaryRows.encodeLong(i + opts.start);
                    String value = "" + (i + opts.start);
                    Mutation m = new Mutation(new Text(row));
                    if (delete) {
                        m.putDelete(CF, CQ);
                    } else {
                        m.put(CF, CQ, new Value(value.getBytes(Constants.UTF8)));
                    }
                    bw.addMutation(m);
                }
                bw.close();
            } else if (opts.mode.equals("verifyDeleted")) {
                Scanner s = connector.createScanner(opts.tableName, opts.auths);
                s.setBatchSize(scanOpts.scanBatchSize);
                Key startKey = new Key(TestBinaryRows.encodeLong(opts.start), CF_BYTES, CQ_BYTES, new byte[0], Long.MAX_VALUE);
                Key stopKey = new Key(TestBinaryRows.encodeLong(opts.start + opts.num - 1L), CF_BYTES, CQ_BYTES, new byte[0], 0L);
                s.setBatchSize(50000);
                s.setRange(new Range(startKey, stopKey));
                for (Map.Entry entry : s) {
                    System.err.println("ERROR : saw entries in range that should be deleted ( first value : " + ((Value)entry.getValue()).toString() + ")");
                    System.err.println("exiting...");
                    System.exit(1);
                }
            } else if (opts.mode.equals("verify")) {
                long t1 = System.currentTimeMillis();
                Scanner s = connector.createScanner(opts.tableName, opts.auths);
                Key startKey = new Key(TestBinaryRows.encodeLong(opts.start), CF_BYTES, CQ_BYTES, new byte[0], Long.MAX_VALUE);
                Key stopKey = new Key(TestBinaryRows.encodeLong(opts.start + opts.num - 1L), CF_BYTES, CQ_BYTES, new byte[0], 0L);
                s.setBatchSize(scanOpts.scanBatchSize);
                s.setRange(new Range(startKey, stopKey));
                long i = opts.start;
                for (Map.Entry e : s) {
                    Key k = (Key)e.getKey();
                    Value v = (Value)e.getValue();
                    TestBinaryRows.checkKeyValue(i, k, v);
                    ++i;
                }
                if (i != opts.start + opts.num) {
                    System.err.println("ERROR : did not see expected number of rows, saw " + (i - opts.start) + " expected " + opts.num);
                    System.err.println("exiting... ARGHHHHHH");
                    System.exit(1);
                }
                long t2 = System.currentTimeMillis();
                System.out.printf("time : %9.2f secs%n", (double)(t2 - t1) / 1000.0);
                System.out.printf("rate : %9.2f entries/sec%n", (double)opts.num / ((double)(t2 - t1) / 1000.0));
            } else if (opts.mode.equals("randomLookups")) {
                int numLookups = 1000;
                Random r = new Random();
                long t1 = System.currentTimeMillis();
                for (int i = 0; i < numLookups; ++i) {
                    long row = (r.nextLong() & Long.MAX_VALUE) % opts.num + opts.start;
                    Scanner s = connector.createScanner(opts.tableName, opts.auths);
                    s.setBatchSize(scanOpts.scanBatchSize);
                    Key startKey = new Key(TestBinaryRows.encodeLong(row), CF_BYTES, CQ_BYTES, new byte[0], Long.MAX_VALUE);
                    Key stopKey = new Key(TestBinaryRows.encodeLong(row), CF_BYTES, CQ_BYTES, new byte[0], 0L);
                    s.setRange(new Range(startKey, stopKey));
                    Iterator si = s.iterator();
                    if (si.hasNext()) {
                        Map.Entry e = (Map.Entry)si.next();
                        Key k = (Key)e.getKey();
                        Value v = (Value)e.getValue();
                        TestBinaryRows.checkKeyValue(row, k, v);
                        if (!si.hasNext()) continue;
                        System.err.println("ERROR : lookup on " + row + " returned more than one result ");
                        System.err.println("exiting...");
                        System.exit(1);
                        continue;
                    }
                    System.err.println("ERROR : lookup on " + row + " failed ");
                    System.err.println("exiting...");
                    System.exit(1);
                }
                long t2 = System.currentTimeMillis();
                System.out.printf("time    : %9.2f secs%n", (double)(t2 - t1) / 1000.0);
                System.out.printf("lookups : %9d keys%n", numLookups);
                System.out.printf("rate    : %9.2f lookups/sec%n", (double)numLookups / ((double)(t2 - t1) / 1000.0));
            } else if (opts.mode.equals("split")) {
                TreeSet<Text> splits = new TreeSet<Text>();
                int shift = (int)opts.start;
                int count = (int)opts.num;
                for (long i = 0L; i < (long)count; ++i) {
                    long splitPoint = i << shift;
                    splits.add(new Text(TestBinaryRows.encodeLong(splitPoint)));
                    System.out.printf("added split point 0x%016x  %,12d%n", splitPoint, splitPoint);
                }
                connector.tableOperations().create(opts.tableName);
                connector.tableOperations().addSplits(opts.tableName, splits);
            } else {
                System.err.println("ERROR : " + opts.mode + " is not a valid operation.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkKeyValue(long expected, Key k, Value v) throws Exception {
        if (expected != TestBinaryRows.decodeLong(TextUtil.getBytes((Text)k.getRow()))) {
            System.err.println("ERROR : expected row " + expected + " saw " + TestBinaryRows.decodeLong(TextUtil.getBytes((Text)k.getRow())));
            System.err.println("exiting...");
            throw new Exception();
        }
        if (!v.toString().equals("" + expected)) {
            System.err.println("ERROR : expected value " + expected + " saw " + v.toString());
            System.err.println("exiting...");
            throw new Exception();
        }
    }

    static {
        long b = 1L;
        for (int i = 0; i < 8; ++i) {
            b |= 1L << i;
        }
        byteOnes = b;
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--mode"}, description="either 'ingest', 'delete', 'randomLookups', 'split', 'verify', 'verifyDeleted'", required=true)
        String mode;
        @Parameter(names={"--start"}, description="the lowest numbered row")
        long start = 0L;
        @Parameter(names={"--count"}, description="number of rows to ingest", required=true)
        long num = 0L;

        Opts() {
        }
    }
}

