/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.Iterator;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.server.tabletserver.NativeMap;
import org.apache.hadoop.io.Text;

public class NativeMapConcurrencyTest {
    private static final byte[] ROW_PREFIX = new byte[]{114};
    private static final byte[] COL_PREFIX = new byte[]{99};
    private static final Text ET = new Text();

    static Mutation nm(int r) {
        return new Mutation(new Text(FastFormat.toZeroPaddedString((long)r, (int)6, (int)10, (byte[])ROW_PREFIX)));
    }

    private static void pc(Mutation m, int c, Value v) {
        m.put(new Text(FastFormat.toZeroPaddedString((long)c, (int)3, (int)10, (byte[])COL_PREFIX)), ET, v);
    }

    static NativeMap create(int numRows, int numCols) {
        NativeMap nm = new NativeMap();
        NativeMapConcurrencyTest.populate(0, numRows, numCols, nm);
        return nm;
    }

    private static void populate(int start, int numRows, int numCols, NativeMap nm) {
        long t1 = System.currentTimeMillis();
        int mc = 1;
        for (int i = 0; i < numRows; ++i) {
            Mutation m = NativeMapConcurrencyTest.nm(i + start);
            for (int j = 0; j < numCols; ++j) {
                Value val = new Value("test".getBytes(Constants.UTF8));
                NativeMapConcurrencyTest.pc(m, j, val);
            }
            nm.mutate(m, mc++);
        }
        long t2 = System.currentTimeMillis();
        System.out.printf("inserted %,d in %,d %,d %,6.2f%n", numRows * numCols, t2 - t1, nm.size(), NativeMapConcurrencyTest.rate(numRows * numCols, t2 - t1));
    }

    private static double rate(int num, long ms) {
        return (double)num / ((double)ms / 1000.0);
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        JCommander jc = new JCommander((Object)opts);
        jc.setProgramName(NativeMapConcurrencyTest.class.getName());
        jc.parse(args);
        if (opts.help) {
            jc.usage();
            return;
        }
        NativeMap nm = NativeMapConcurrencyTest.create(opts.rows, opts.cols);
        NativeMapConcurrencyTest.runTest(nm, opts.rows, opts.cols, opts.threads, opts.writeThreads);
        nm.delete();
    }

    private static void runTest(NativeMap nm, int rows, int cols, int numReadThreads, int writeThreads) {
        Thread[] threads = new Thread[numReadThreads + writeThreads];
        for (int i = 0; i < numReadThreads; ++i) {
            threads[i] = new Thread(new ScanTask(nm));
        }
        int start = 0;
        for (int i = numReadThreads; i < writeThreads + numReadThreads; ++i) {
            threads[i] = new Thread(new WriteTask(start, rows, cols, nm));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static class WriteTask
    implements Runnable {
        private int start;
        private int rows;
        private int cols;
        private NativeMap nm;

        WriteTask(int start, int rows, int cols, NativeMap nm) {
            this.start = start;
            this.rows = rows;
            this.cols = cols;
            this.nm = nm;
        }

        @Override
        public void run() {
            NativeMapConcurrencyTest.populate(this.start, this.rows, this.cols, this.nm);
        }
    }

    static class ScanTask
    implements Runnable {
        private NativeMap nm;

        ScanTask(NativeMap nm) {
            this.nm = nm;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                Iterator iter = this.nm.iterator();
                long t1 = System.currentTimeMillis();
                int count = 0;
                while (iter.hasNext()) {
                    ++count;
                    iter.next();
                }
                long t2 = System.currentTimeMillis();
                System.out.printf("%d %,d %,d %,d %,d %,6.2f%n", Thread.currentThread().getId(), t2 - t1, t1, t2, count, NativeMapConcurrencyTest.rate(count, t2 - t1));
            }
        }
    }

    static class Opts {
        @Parameter(names={"--rows"}, description="rows", required=true)
        int rows = 0;
        @Parameter(names={"--cols"}, description="cols")
        int cols = 1;
        @Parameter(names={"--threads"}, description="threads")
        int threads = 1;
        @Parameter(names={"--writeThreads"}, description="write threads")
        int writeThreads = 1;
        @Parameter(names={"-help"}, help=true)
        boolean help = false;

        Opts() {
        }
    }
}

