/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.RecoveryStatus;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.monitor.Monitor;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.trace.instrument.Tracer;

public class GetMasterStats {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MasterClientService.Client client = null;
        MasterMonitorInfo stats = null;
        try {
            client = MasterClient.getConnectionWithRetry((Instance)HdfsZooInstance.getInstance());
            stats = client.getMasterStats(Tracer.traceInfo(), SecurityConstants.getSystemCredentials());
        }
        finally {
            if (client != null) {
                MasterClient.close((MasterClientService.Iface)client);
            }
        }
        GetMasterStats.out(0, "State: " + stats.state.name(), new Object[0]);
        GetMasterStats.out(0, "Goal State: " + stats.goalState.name(), new Object[0]);
        if (stats.serversShuttingDown != null && stats.serversShuttingDown.size() > 0) {
            GetMasterStats.out(0, "Servers to shutdown", new Object[0]);
            for (String string : stats.serversShuttingDown) {
                GetMasterStats.out(1, "%s", string);
            }
        }
        GetMasterStats.out(0, "Unassigned tablets: %d", stats.unassignedTablets);
        if (stats.badTServers != null && stats.badTServers.size() > 0) {
            GetMasterStats.out(0, "Bad servers", new Object[0]);
            for (Map.Entry entry : stats.badTServers.entrySet()) {
                GetMasterStats.out(1, "%s: %d", entry.getKey(), (Byte)entry.getValue());
            }
        }
        if (stats.tableMap != null && stats.tableMap.size() > 0) {
            GetMasterStats.out(0, "Tables", new Object[0]);
            for (Map.Entry entry : stats.tableMap.entrySet()) {
                TableInfo v = (TableInfo)entry.getValue();
                GetMasterStats.out(1, "%s", entry.getKey());
                GetMasterStats.out(2, "Records: %d", v.recs);
                GetMasterStats.out(2, "Records in Memory: %d", v.recsInMemory);
                GetMasterStats.out(2, "Tablets: %d", v.tablets);
                GetMasterStats.out(2, "Online Tablets: %d", v.onlineTablets);
                GetMasterStats.out(2, "Ingest Rate: %.2f", v.ingestRate);
                GetMasterStats.out(2, "Query Rate: %.2f", v.queryRate);
            }
        }
        if (stats.tServerInfo != null && stats.tServerInfo.size() > 0) {
            GetMasterStats.out(0, "Tablet Servers", new Object[0]);
            long now = System.currentTimeMillis();
            for (TabletServerStatus server : stats.tServerInfo) {
                TableInfo summary = Monitor.summarizeTableStats((TabletServerStatus)server);
                GetMasterStats.out(1, "Name: %s", server.name);
                GetMasterStats.out(2, "Ingest: %.2f", summary.ingestRate);
                GetMasterStats.out(2, "Last Contact: %s", server.lastContact);
                GetMasterStats.out(2, "OS Load Average: %.2f", server.osLoad);
                GetMasterStats.out(2, "Queries: %.2f", summary.queryRate);
                GetMasterStats.out(2, "Time Difference: %.1f", (double)(now - server.lastContact) / 1000.0);
                GetMasterStats.out(2, "Total Records: %d", summary.recs);
                GetMasterStats.out(2, "Lookups: %d", server.lookups);
                if (server.holdTime > 0L) {
                    GetMasterStats.out(2, "Hold Time: %d", server.holdTime);
                }
                if (server.tableMap != null && server.tableMap.size() > 0) {
                    GetMasterStats.out(2, "Tables", new Object[0]);
                    for (Map.Entry status : server.tableMap.entrySet()) {
                        TableInfo info = (TableInfo)status.getValue();
                        GetMasterStats.out(3, "Table: %s", status.getKey());
                        GetMasterStats.out(4, "Tablets: %d", info.onlineTablets);
                        GetMasterStats.out(4, "Records: %d", info.recs);
                        GetMasterStats.out(4, "Records in Memory: %d", info.recsInMemory);
                        GetMasterStats.out(4, "Ingest: %.2f", info.ingestRate);
                        GetMasterStats.out(4, "Queries: %.2f", info.queryRate);
                        GetMasterStats.out(4, "Major Compacting: %d", info.majors == null ? 0 : info.majors.running);
                        GetMasterStats.out(4, "Queued for Major Compaction: %d", info.majors == null ? 0 : info.majors.queued);
                        GetMasterStats.out(4, "Minor Compacting: %d", info.minors == null ? 0 : info.minors.running);
                        GetMasterStats.out(4, "Queued for Minor Compaction: %d", info.minors == null ? 0 : info.minors.queued);
                    }
                }
                GetMasterStats.out(2, "Recoveries: %d", server.logSorts.size());
                for (RecoveryStatus sort : server.logSorts) {
                    GetMasterStats.out(3, "File: %s", sort.name);
                    GetMasterStats.out(3, "Progress: %.2f%%", sort.progress * 100.0);
                    GetMasterStats.out(3, "Time running: %s", (double)sort.runtime / 1000.0);
                }
            }
        }
    }

    private static void out(int indent, String string, Object ... args) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(String.format(string, args));
    }
}

