/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.server.cli.ClientOnDefaultTable;
import org.apache.hadoop.io.Text;

public class CreateTestTable {
    private static void readBack(Connector conn, Opts opts, ScannerOpts scanOpts) throws Exception {
        Scanner scanner = conn.createScanner("mrtest1", opts.auths);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        int count = 0;
        for (Map.Entry elt : scanner) {
            String expected = String.format("%05d", count);
            assert (((Key)elt.getKey()).getRow().toString().equals(expected));
            ++count;
        }
        assert (opts.count == count);
    }

    public static void main(String[] args) throws Exception {
        String program = CreateTestTable.class.getName();
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        ScannerOpts scanOpts = new ScannerOpts();
        opts.parseArgs(program, args, new Object[]{bwOpts, scanOpts});
        Connector connector = opts.getConnector();
        if (!opts.readOnly) {
            TreeSet<Text> keys = new TreeSet<Text>();
            for (int i = 0; i < opts.count / 100; ++i) {
                keys.add(new Text(String.format("%05d", i * 100)));
            }
            connector.tableOperations().create(opts.getTableName());
            connector.tableOperations().addSplits(opts.getTableName(), keys);
            BatchWriter b = connector.createBatchWriter(opts.getTableName(), bwOpts.getBatchWriterConfig());
            for (int i = 0; i < opts.count; ++i) {
                Mutation m = new Mutation(new Text(String.format("%05d", i)));
                m.put(new Text("col" + Integer.toString(i % 3 + 1)), new Text("qual"), new Value("junk".getBytes(Constants.UTF8)));
                b.addMutation(m);
            }
            b.close();
        }
        CreateTestTable.readBack(connector, opts, scanOpts);
        opts.stopTracing();
    }

    static class Opts
    extends ClientOnDefaultTable {
        @Parameter(names={"-readonly", "--readonly"}, description="read only")
        boolean readOnly = false;
        @Parameter(names={"-count", "--count"}, description="count", required=true)
        int count = 10000;

        Opts() {
            super("mrtest1");
        }
    }
}

