/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.test.TestIngest;

public class CreateRFiles {
    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(CreateRFiles.class.getName(), args, new Object[0]);
        long splitSize = Math.round((double)(opts.end - opts.start) / (double)opts.numsplits);
        long currStart = opts.start;
        long currEnd = opts.start + splitSize;
        ExecutorService threadPool = Executors.newFixedThreadPool(opts.numThreads);
        int count = 0;
        while (currEnd <= opts.end && currStart < currEnd) {
            final String tia = String.format("--rfile %s/mf%05d --timestamp 1 --size 50 --random 56 --rows %d --start %d --user root", opts.outputDirectory, count, currEnd - currStart, currStart);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        TestIngest.main(tia.split(" "));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            threadPool.execute(r);
            ++count;
            currStart = currEnd;
            currEnd = Math.min(opts.end, currStart + splitSize);
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            try {
                threadPool.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--output"}, description="the destiation directory")
        String outputDirectory;
        @Parameter(names={"--numThreads"}, description="number of threads to use when generating files")
        int numThreads = 4;
        @Parameter(names={"--start"}, description="the start number for test data")
        long start = 0L;
        @Parameter(names={"--end"}, description="the maximum number for test data")
        long end = 10000000L;
        @Parameter(names={"--splits"}, description="the number of splits in the data")
        long numsplits = 4L;

        Opts() {
        }
    }
}

