/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.cli.ClientOnRequiredTable;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BulkImportDirectory {
    public static void main(String[] args) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        Opts opts = new Opts();
        if (args.length == 5) {
            System.err.println("Deprecated syntax for BulkImportDirectory, please use the new style (see --help)");
            String user = args[0];
            byte[] pass = args[1].getBytes(Constants.UTF8);
            String tableName = args[2];
            String dir = args[3];
            String failureDir = args[4];
            Path failureDirPath = new Path(failureDir);
            fs.delete(failureDirPath, true);
            fs.mkdirs(failureDirPath);
            HdfsZooInstance.getInstance().getConnector(user, (AuthenticationToken)new PasswordToken(pass)).tableOperations().importDirectory(tableName, dir, failureDir, false);
        } else {
            opts.parseArgs(BulkImportDirectory.class.getName(), args, new Object[0]);
            fs.delete(new Path(opts.failures), true);
            fs.mkdirs(new Path(opts.failures));
            opts.getConnector().tableOperations().importDirectory(opts.tableName, opts.source, opts.failures, false);
        }
    }

    static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"-s", "--source"}, description="directory to import from")
        String source = null;
        @Parameter(names={"-f", "--failures"}, description="directory to copy failures into: will be deleted before the bulk import")
        String failures = null;
        @Parameter(description="<username> <password> <tablename> <sourcedir> <failuredir>")
        List<String> args = new ArrayList<String>();

        Opts() {
        }
    }
}

