/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs.providers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsRandomAccessContent
implements RandomAccessContent {
    private final FileSystem fs;
    private final Path path;
    private final FSDataInputStream fis;

    public HdfsRandomAccessContent(Path path, FileSystem fs) throws IOException {
        this.fs = fs;
        this.path = path;
        this.fis = this.fs.open(this.path);
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public long getFilePointer() throws IOException {
        return this.fis.getPos();
    }

    public InputStream getInputStream() throws IOException {
        return this.fis;
    }

    public long length() throws IOException {
        return this.fs.getFileStatus(this.path).getLen();
    }

    public boolean readBoolean() throws IOException {
        return this.fis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.fis.readByte();
    }

    public char readChar() throws IOException {
        return this.fis.readChar();
    }

    public double readDouble() throws IOException {
        return this.fis.readDouble();
    }

    public float readFloat() throws IOException {
        return this.fis.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int readInt() throws IOException {
        return this.fis.readInt();
    }

    public String readLine() throws IOException {
        BufferedReader d = new BufferedReader(new InputStreamReader((InputStream)this.fis, Charset.forName("UTF-8")));
        return d.readLine();
    }

    public long readLong() throws IOException {
        return this.fis.readLong();
    }

    public short readShort() throws IOException {
        return this.fis.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.fis.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.fis.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.fis.readUTF();
    }

    public void seek(long pos) throws IOException {
        this.fis.seek(pos);
    }

    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBoolean(boolean v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeByte(int v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeChar(int v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeDouble(double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeFloat(float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeInt(int v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeLong(long v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeShort(int v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeUTF(String s) throws IOException {
        throw new UnsupportedOperationException();
    }
}

