/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.form.DefaultStartFormHandler;
import org.activiti.engine.impl.form.DefaultTaskFormHandler;
import org.activiti.engine.impl.form.StartFormHandler;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.repository.ProcessDefinition;

public class FormHandlerUtil {
    public static StartFormHandler getStartFormHandler(CommandContext commandContext, ProcessDefinition processDefinition) {
        DefaultStartFormHandler startFormHandler = new DefaultStartFormHandler();
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        FlowElement initialFlowElement = process.getInitialFlowElement();
        if (initialFlowElement instanceof StartEvent) {
            StartEvent startEvent = (StartEvent)initialFlowElement;
            List formProperties = startEvent.getFormProperties();
            String formKey = startEvent.getFormKey();
            DeploymentEntity deploymentEntity = (DeploymentEntity)commandContext.getDeploymentEntityManager().findById(processDefinition.getDeploymentId());
            startFormHandler.parseConfiguration(formProperties, formKey, deploymentEntity, processDefinition);
            return startFormHandler;
        }
        return null;
    }

    public static TaskFormHandler getTaskFormHandlder(String processDefinitionId, String taskId) {
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        FlowElement flowElement = process.getFlowElement(taskId, true);
        if (flowElement instanceof UserTask) {
            UserTask userTask = (UserTask)flowElement;
            ProcessDefinition processDefinitionEntity = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
            DeploymentEntity deploymentEntity = (DeploymentEntity)Context.getProcessEngineConfiguration().getDeploymentEntityManager().findById(processDefinitionEntity.getDeploymentId());
            DefaultTaskFormHandler taskFormHandler = new DefaultTaskFormHandler();
            taskFormHandler.parseConfiguration(userTask.getFormProperties(), userTask.getFormKey(), deploymentEntity, processDefinitionEntity);
            return taskFormHandler;
        }
        return null;
    }

    public static TaskFormHandler getTaskFormHandlder(TaskEntity taskEntity) {
        if (taskEntity.getProcessDefinitionId() != null) {
            return FormHandlerUtil.getTaskFormHandlder(taskEntity.getProcessDefinitionId(), taskEntity.getTaskDefinitionKey());
        }
        return null;
    }
}

