/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.repository.ProcessDefinition;

public class IsActiviti5ProcessDefinitionCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public IsActiviti5ProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        if (!commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled()) {
            return false;
        }
        ProcessDefinition processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition.getEngineVersion() != null) {
            if ("activiti-5".equals(processDefinition.getEngineVersion())) {
                if (commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled()) {
                    return true;
                }
            } else {
                throw new ActivitiException("Invalid 'engine' for process definition " + processDefinition.getId() + " : " + processDefinition.getEngineVersion());
            }
        }
        return false;
    }
}

