/*
 * Decompiled with CFR 0.152.
 */
package no.ecc.vectortile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import vector_tile.VectorTile;

public class VectorTileEncoder {
    private final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private final int extent;
    private final double minimumLength;
    private final double minimumArea;
    private final Geometry clipGeometry;
    private final boolean autoScale;
    private long autoincrement;
    private final boolean autoincrementIds;
    private final double simplificationDistanceTolerance;
    private int x = 0;
    private int y = 0;

    public VectorTileEncoder() {
        this(4096, 8, true);
    }

    public VectorTileEncoder(int extent) {
        this(extent, 8, true);
    }

    public VectorTileEncoder(int extent, int clipBuffer, boolean autoScale) {
        this(extent, clipBuffer, autoScale, false);
    }

    public VectorTileEncoder(int extent, int clipBuffer, boolean autoScale, boolean autoincrementIds) {
        this(extent, clipBuffer, autoScale, autoincrementIds, -1.0);
    }

    public VectorTileEncoder(int extent, int clipBuffer, boolean autoScale, boolean autoincrementIds, double simplificationDistanceTolerance) {
        this.extent = extent;
        this.autoScale = autoScale;
        this.minimumLength = autoScale ? 256.0 / (double)extent : 1.0;
        this.minimumArea = this.minimumLength * this.minimumLength;
        this.autoincrementIds = autoincrementIds;
        this.autoincrement = 1L;
        this.simplificationDistanceTolerance = simplificationDistanceTolerance;
        int size = autoScale ? 256 : extent;
        this.clipGeometry = VectorTileEncoder.createTileEnvelope(clipBuffer, size);
    }

    private static Geometry createTileEnvelope(int buffer, int size) {
        Coordinate[] coords;
        coords = new Coordinate[]{new Coordinate((double)(0 - buffer), (double)(size + buffer)), new Coordinate((double)(size + buffer), (double)(size + buffer)), new Coordinate((double)(size + buffer), (double)(0 - buffer)), new Coordinate((double)(0 - buffer), (double)(0 - buffer)), coords[0]};
        return new GeometryFactory().createPolygon(coords);
    }

    public void addFeature(String layerName, Map<String, ?> attributes, Geometry geometry) {
        long l;
        if (this.autoincrementIds) {
            long l2 = this.autoincrement;
            l = l2;
            this.autoincrement = l2 + 1L;
        } else {
            l = -1L;
        }
        this.addFeature(layerName, attributes, geometry, l);
    }

    public void addFeature(String layerName, Map<String, ?> attributes, Geometry geometry, long id) {
        if (geometry instanceof MultiPolygon && geometry.getArea() < this.minimumArea) {
            return;
        }
        if (geometry instanceof Polygon && geometry.getArea() < this.minimumArea) {
            return;
        }
        if (geometry instanceof LineString && geometry.getLength() < this.minimumLength) {
            return;
        }
        if (geometry.getClass().equals(GeometryCollection.class)) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry subGeometry = geometry.getGeometryN(i);
                this.addFeature(layerName, attributes, subGeometry, id);
            }
            return;
        }
        if (geometry instanceof Point) {
            if (!this.clipCovers(geometry)) {
                return;
            }
        } else {
            geometry = this.clipGeometry(geometry);
        }
        if (this.simplificationDistanceTolerance > 0.0 && !(geometry instanceof Point)) {
            geometry = TopologyPreservingSimplifier.simplify((Geometry)geometry, (double)this.simplificationDistanceTolerance);
        }
        if (geometry.isEmpty()) {
            return;
        }
        Layer layer = this.layers.get(layerName);
        if (layer == null) {
            layer = new Layer();
            this.layers.put(layerName, layer);
        }
        Feature feature = new Feature();
        feature.geometry = geometry;
        feature.id = id;
        this.autoincrement = Math.max(this.autoincrement, id + 1L);
        for (Map.Entry<String, ?> e : attributes.entrySet()) {
            if (e.getValue() == null) continue;
            feature.tags.add(layer.key(e.getKey()));
            feature.tags.add(layer.value(e.getValue()));
        }
        layer.features.add(feature);
    }

    protected boolean clipCovers(Geometry geom) {
        if (geom instanceof Point) {
            Point p = (Point)geom;
            return this.clipGeometry.getEnvelopeInternal().covers(p.getCoordinate());
        }
        return this.clipGeometry.covers(geom);
    }

    protected Geometry clipGeometry(Geometry geometry) {
        try {
            Geometry original = geometry;
            geometry = this.clipGeometry.intersection(original);
            if (geometry.isEmpty() && original.intersects(this.clipGeometry)) {
                Geometry originalViaWkt = new WKTReader().read(original.toText());
                geometry = this.clipGeometry.intersection(originalViaWkt);
            }
            return geometry;
        }
        catch (TopologyException e) {
            return geometry;
        }
        catch (ParseException e1) {
            return geometry;
        }
    }

    public byte[] encode() {
        VectorTile.Tile.Builder tile = VectorTile.Tile.newBuilder();
        for (Map.Entry<String, Layer> e : this.layers.entrySet()) {
            String layerName = e.getKey();
            Layer layer = e.getValue();
            VectorTile.Tile.Layer.Builder tileLayer = VectorTile.Tile.Layer.newBuilder();
            tileLayer.setVersion(2);
            tileLayer.setName(layerName);
            tileLayer.addAllKeys(layer.keys());
            for (Object value : layer.values()) {
                VectorTile.Tile.Value.Builder tileValue = VectorTile.Tile.Value.newBuilder();
                if (value instanceof String) {
                    tileValue.setStringValue((String)value);
                } else if (value instanceof Integer) {
                    tileValue.setSintValue(((Integer)value).intValue());
                } else if (value instanceof Long) {
                    tileValue.setSintValue((Long)value);
                } else if (value instanceof Float) {
                    tileValue.setFloatValue(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    tileValue.setDoubleValue((Double)value);
                } else if (value instanceof Boolean) {
                    tileValue.setBoolValue((Boolean)value);
                } else {
                    tileValue.setStringValue(value.toString());
                }
                tileLayer.addValues(tileValue.build());
            }
            tileLayer.setExtent(this.extent);
            for (Feature feature : layer.features) {
                Geometry geometry = feature.geometry;
                VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
                featureBuilder.addAllTags(feature.tags);
                if (feature.id >= 0L) {
                    featureBuilder.setId(feature.id);
                }
                featureBuilder.setType(VectorTileEncoder.toGeomType(geometry));
                this.x = 0;
                this.y = 0;
                featureBuilder.addAllGeometry(this.commands(geometry));
                tileLayer.addFeatures(featureBuilder.build());
            }
            tile.addLayers(tileLayer.build());
        }
        return tile.build().toByteArray();
    }

    static VectorTile.Tile.GeomType toGeomType(Geometry geometry) {
        if (geometry instanceof Point) {
            return VectorTile.Tile.GeomType.POINT;
        }
        if (geometry instanceof MultiPoint) {
            return VectorTile.Tile.GeomType.POINT;
        }
        if (geometry instanceof LineString) {
            return VectorTile.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof MultiLineString) {
            return VectorTile.Tile.GeomType.LINESTRING;
        }
        if (geometry instanceof Polygon) {
            return VectorTile.Tile.GeomType.POLYGON;
        }
        if (geometry instanceof MultiPolygon) {
            return VectorTile.Tile.GeomType.POLYGON;
        }
        return VectorTile.Tile.GeomType.UNKNOWN;
    }

    static boolean shouldClosePath(Geometry geometry) {
        return geometry instanceof Polygon || geometry instanceof LinearRing;
    }

    List<Integer> commands(Geometry geometry) {
        if (geometry instanceof MultiLineString) {
            return this.commands((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.commands((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.commands((MultiPolygon)geometry);
        }
        return this.commands(geometry.getCoordinates(), VectorTileEncoder.shouldClosePath(geometry), geometry instanceof MultiPoint);
    }

    List<Integer> commands(MultiLineString mls) {
        ArrayList<Integer> commands = new ArrayList<Integer>();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            commands.addAll(this.commands(mls.getGeometryN(i).getCoordinates(), false));
        }
        return commands;
    }

    List<Integer> commands(MultiPolygon mp) {
        ArrayList<Integer> commands = new ArrayList<Integer>();
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)mp.getGeometryN(i);
            commands.addAll(this.commands(polygon));
        }
        return commands;
    }

    List<Integer> commands(Polygon polygon) {
        ArrayList<Integer> commands = new ArrayList<Integer>();
        LinearRing exteriorRing = polygon.getExteriorRing();
        if (!Orientation.isCCW((Coordinate[])exteriorRing.getCoordinates())) {
            exteriorRing = (LineString)exteriorRing.reverse();
        }
        commands.addAll(this.commands(exteriorRing.getCoordinates(), true));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing interiorRing = polygon.getInteriorRingN(i);
            if (Orientation.isCCW((Coordinate[])interiorRing.getCoordinates())) {
                interiorRing = (LineString)interiorRing.reverse();
            }
            commands.addAll(this.commands(interiorRing.getCoordinates(), true));
        }
        return commands;
    }

    List<Integer> commands(Coordinate[] cs, boolean closePathAtEnd) {
        return this.commands(cs, closePathAtEnd, false);
    }

    List<Integer> commands(Coordinate[] cs, boolean closePathAtEnd, boolean multiPoint) {
        if (cs.length == 0) {
            throw new IllegalArgumentException("empty geometry");
        }
        ArrayList<Integer> r = new ArrayList<Integer>();
        int lineToIndex = 0;
        int lineToLength = 0;
        double scale = this.autoScale ? (double)this.extent / 256.0 : 1.0;
        for (int i = 0; i < cs.length; ++i) {
            Coordinate c = cs[i];
            if (i == 0) {
                r.add(VectorTileEncoder.commandAndLength(1, multiPoint ? cs.length : 1));
            }
            int _x = (int)Math.round(c.x * scale);
            int _y = (int)Math.round(c.y * scale);
            if (i > 0 && _x == this.x && _y == this.y) {
                --lineToLength;
                continue;
            }
            if (closePathAtEnd && cs.length > 1 && i == cs.length - 1 && cs[0].equals((Object)c)) {
                --lineToLength;
                continue;
            }
            r.add(VectorTileEncoder.zigZagEncode(_x - this.x));
            r.add(VectorTileEncoder.zigZagEncode(_y - this.y));
            this.x = _x;
            this.y = _y;
            if (i != 0 || cs.length <= 1 || multiPoint) continue;
            lineToIndex = r.size();
            lineToLength = cs.length - 1;
            r.add(VectorTileEncoder.commandAndLength(2, lineToLength));
        }
        if (lineToIndex > 0) {
            if (lineToLength == 0) {
                r.remove(lineToIndex);
            } else {
                r.set(lineToIndex, VectorTileEncoder.commandAndLength(2, lineToLength));
            }
        }
        if (closePathAtEnd) {
            r.add(VectorTileEncoder.commandAndLength(7, 1));
        }
        return r;
    }

    static int commandAndLength(int command, int repeat) {
        return repeat << 3 | command;
    }

    static int zigZagEncode(int n) {
        return n << 1 ^ n >> 31;
    }

    private static final class Feature {
        long id;
        Geometry geometry;
        final List<Integer> tags = new ArrayList<Integer>();

        private Feature() {
        }
    }

    private static final class Layer {
        final List<Feature> features = new ArrayList<Feature>();
        private final Map<String, Integer> keys = new LinkedHashMap<String, Integer>();
        private final Map<Object, Integer> values = new LinkedHashMap<Object, Integer>();

        private Layer() {
        }

        public Integer key(String key) {
            Integer i = this.keys.get(key);
            if (i == null) {
                i = this.keys.size();
                this.keys.put(key, i);
            }
            return i;
        }

        public List<String> keys() {
            return new ArrayList<String>(this.keys.keySet());
        }

        public Integer value(Object value) {
            Integer i = this.values.get(value);
            if (i == null) {
                i = this.values.size();
                this.values.put(value, i);
            }
            return i;
        }

        public List<Object> values() {
            return Collections.unmodifiableList(new ArrayList<Object>(this.values.keySet()));
        }
    }
}

