/*
 * Decompiled with CFR 0.152.
 */
package net.anthavio.airbrake.http;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.anthavio.airbrake.AirbrakeNoticeBuilderUsingFilteredSystemProperties;
import net.anthavio.airbrake.http.RequestEnhancer;

public class HttpServletRequestEnhancer
implements RequestEnhancer<HttpServletRequest> {
    private static final ThreadLocal<HttpServletRequest> tlRequest = new ThreadLocal();

    @Override
    public void setRequest(HttpServletRequest request) {
        tlRequest.set(request);
    }

    @Override
    public void endRequest(HttpServletRequest request) {
        tlRequest.remove();
    }

    @Override
    public void enhance(AirbrakeNoticeBuilderUsingFilteredSystemProperties builder) {
        HttpServletRequest request = tlRequest.get();
        if (request != null) {
            this.doRequest(builder, request);
            this.doParameters(builder, request);
            HttpSession session = request.getSession(false);
            if (session != null) {
                this.doSession(session, builder);
            }
        }
    }

    protected void doRequest(AirbrakeNoticeBuilderUsingFilteredSystemProperties builder, HttpServletRequest request) {
        StringBuffer urlBuffer = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null && query.length() != 0) {
            urlBuffer.append('?').append(query);
        }
        builder.setRequest(urlBuffer.toString(), request.getContextPath());
    }

    protected void doParameters(AirbrakeNoticeBuilderUsingFilteredSystemProperties builder, HttpServletRequest request) {
        HashMap<String, Object> paramap = new HashMap<String, Object>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String pname = (String)pnames.nextElement();
            CharSequence[] pvalues = request.getParameterValues(pname);
            if (pvalues.length == 1) {
                paramap.put(pname, pvalues[0]);
                continue;
            }
            paramap.put(pname, String.join((CharSequence)",", pvalues));
        }
        builder.request(paramap);
    }

    protected void doSession(HttpSession session, AirbrakeNoticeBuilderUsingFilteredSystemProperties builder) {
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        Enumeration snames = session.getAttributeNames();
        while (snames.hasMoreElements()) {
            String sname = (String)snames.nextElement();
            Object svalue = session.getAttribute(sname);
            sessionMap.put(sname, svalue);
        }
        builder.session(sessionMap);
    }
}

