/*
 * Decompiled with CFR 0.152.
 */
package net.anthavio.airbrake.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.anthavio.airbrake.http.HttpServletRequestEnhancerFactory;
import net.anthavio.airbrake.http.RequestEnhancer;
import net.anthavio.airbrake.http.RequestEnhancerFactory;

public class AirbrakeServletRequestFilter
implements Filter {
    private RequestEnhancer<HttpServletRequest> requestEnhancer;

    public void init(FilterConfig filterConfig) throws ServletException {
        String factoryClassName = filterConfig.getInitParameter("requestEnhancerFactory");
        if (factoryClassName != null) {
            RequestEnhancerFactory factory;
            try {
                factory = (RequestEnhancerFactory)Class.forName(factoryClassName).newInstance();
            }
            catch (Exception x) {
                throw new ServletException("Cannot create " + factoryClassName, (Throwable)x);
            }
            this.requestEnhancer = factory.get();
        } else {
            this.requestEnhancer = new HttpServletRequestEnhancerFactory().get();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            this.requestEnhancer.setRequest(httpRequest);
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                this.requestEnhancer.endRequest(httpRequest);
            }
        }
    }
}

