/*
 * Decompiled with CFR 0.152.
 */
package net.anthavio.airbrake;

import airbrake.AirbrakeNoticeBuilder;
import airbrake.Backtrace;
import airbrake.BacktraceLine;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.MDC;

public class AirbrakeNoticeBuilderUsingFilteredSystemProperties
extends AirbrakeNoticeBuilder {
    public AirbrakeNoticeBuilderUsingFilteredSystemProperties(String apiKey, String errorMessage, StackTraceElement element, String env) {
        super(apiKey, errorMessage, env);
        if (element != null) {
            LinkedList<String> list = new LinkedList<String>();
            list.add(new BacktraceLine(element.getClassName(), element.getFileName(), element.getLineNumber(), element.getMethodName()).toString());
            this.backtrace(new Backtrace(list));
        }
        this.environment(System.getProperties());
        this.addMDCToSession();
        this.standardEnvironmentFilters();
        this.ec2EnvironmentFilters();
    }

    public AirbrakeNoticeBuilderUsingFilteredSystemProperties(String apiKey, Backtrace backtraceBuilder, Throwable throwable, String env) {
        super(apiKey, backtraceBuilder, throwable, env);
        this.environment(System.getProperties());
        this.addMDCToSession();
        this.standardEnvironmentFilters();
        this.ec2EnvironmentFilters();
    }

    private void addMDCToSession() {
        Map map = MDC.getCopyOfContextMap();
        if (map != null) {
            this.addSessionKey(":key", Integer.toString(map.hashCode()));
            this.addSessionKey(":data", map);
        }
    }

    public void request(Map<String, Object> request) {
        super.request(request);
    }

    public void session(Map<String, Object> session) {
        super.session(session);
    }

    public void setRequest(String url, String component) {
        super.setRequest(url, component);
    }
}

