/*
 * Decompiled with CFR 0.152.
 */
package net.anthavio.airbrake;

import airbrake.AirbrakeNotifier;
import airbrake.Backtrace;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import java.util.LinkedList;
import net.anthavio.airbrake.AirbrakeNoticeBuilderUsingFilteredSystemProperties;
import net.anthavio.airbrake.http.HttpServletRequestEnhancerFactory;
import net.anthavio.airbrake.http.RequestEnhancer;
import net.anthavio.airbrake.http.RequestEnhancerFactory;

public class AirbrakeLogbackAppender
extends AppenderBase<ILoggingEvent> {
    private final AirbrakeNotifier airbrakeNotifier;
    private String apiKey;
    private String env;
    private String requestEnhancerFactory;
    private RequestEnhancer requestEnhancer;
    private Notify notify = Notify.EXCEPTIONS;
    private boolean enabled = true;
    private Backtrace backtraceBuilder = new Backtrace(new LinkedList());

    public AirbrakeLogbackAppender() {
        this.airbrakeNotifier = new AirbrakeNotifier();
    }

    protected AirbrakeLogbackAppender(AirbrakeNotifier airbrakeNotifier) {
        this.airbrakeNotifier = airbrakeNotifier;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public Backtrace getBacktraceBuilder() {
        return this.backtraceBuilder;
    }

    public void setBacktraceBuilder(Backtrace backtraceBuilder) {
        this.backtraceBuilder = backtraceBuilder;
    }

    public String getRequestEnhancerFactory() {
        return this.requestEnhancerFactory;
    }

    public void setRequestEnhancerFactory(String requestEnhancerFactory) {
        this.requestEnhancerFactory = requestEnhancerFactory;
    }

    public void setUrl(String url) {
        if (url == null || !url.startsWith("http")) {
            throw new IllegalArgumentException("Wrong url: " + url);
        }
        this.airbrakeNotifier.setUrl(url);
    }

    public Notify getNotify() {
        return this.notify;
    }

    public void setNotify(Notify notify) {
        this.notify = notify;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void append(ILoggingEvent event) {
        if (!this.enabled || this.notify == Notify.OFF) {
            return;
        }
        IThrowableProxy proxy = event.getThrowableProxy();
        if (proxy != null) {
            Throwable throwable = ((ThrowableProxy)proxy).getThrowable();
            AirbrakeNoticeBuilderUsingFilteredSystemProperties builder = new AirbrakeNoticeBuilderUsingFilteredSystemProperties(this.apiKey, this.backtraceBuilder, throwable, this.env);
            if (this.requestEnhancer != null) {
                this.requestEnhancer.enhance(builder);
            }
            this.airbrakeNotifier.notify(builder.newNotice());
        } else if (this.notify == Notify.ALL) {
            StackTraceElement[] stackTrace = event.getCallerData();
            AirbrakeNoticeBuilderUsingFilteredSystemProperties builder = new AirbrakeNoticeBuilderUsingFilteredSystemProperties(this.apiKey, event.getFormattedMessage(), stackTrace[0], this.env);
            if (this.requestEnhancer != null) {
                this.requestEnhancer.enhance(builder);
            }
            this.airbrakeNotifier.notify(builder.newNotice());
        }
    }

    public void stop() {
        super.stop();
    }

    public void start() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            this.addError("API key not set for the appender named [" + this.name + "].");
        }
        if (this.env == null || this.env.isEmpty()) {
            this.addError("Environment not set for the appender named [" + this.name + "].");
        }
        if (this.requestEnhancerFactory != null) {
            RequestEnhancerFactory factory = null;
            try {
                factory = (RequestEnhancerFactory)Class.forName(this.requestEnhancerFactory).newInstance();
            }
            catch (Exception x) {
                throw new IllegalStateException("Cannot create " + this.requestEnhancerFactory, x);
            }
            this.requestEnhancer = factory.get();
        } else if (HttpServletRequestEnhancerFactory.isServletApi()) {
            this.requestEnhancer = new HttpServletRequestEnhancerFactory().get();
        }
        super.start();
    }

    public static enum Notify {
        ALL,
        EXCEPTIONS,
        OFF;

    }
}

