/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit.format;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.ResourceBundle;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.AnnotatedUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.SI;
import javax.measure.unit.TransformedUnit;
import javax.measure.unit.UCUM;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javax.measure.unit.format.ParseException;
import javax.measure.unit.format.Prefix;
import javax.measure.unit.format.SymbolMapImpl;
import javax.measure.unit.format.TokenMgrError;
import javax.measure.unit.format.UCUMParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UCUMFormat
extends UnitFormat {
    private static final long serialVersionUID = -7753687108842507677L;
    private static final String BUNDLE_BASE = UCUMFormat.class.getName();
    final SymbolMapImpl _symbolMap;

    public static UCUMFormat getPrintInstance() {
        return Print.DEFAULT;
    }

    public static UCUMFormat getPrintInstance(SymbolMapImpl symbolMap) {
        return new Print(symbolMap);
    }

    public static UCUMFormat getCaseSensitiveInstance() {
        return Parsing.DEFAULT_CS;
    }

    public static UCUMFormat getCaseSensitiveInstance(SymbolMapImpl symbolMap) {
        return new Parsing(symbolMap, true);
    }

    public static UCUMFormat getCaseInsensitiveInstance() {
        return Parsing.DEFAULT_CI;
    }

    public static UCUMFormat getCaseInsensitiveInstance(SymbolMapImpl symbolMap) {
        return new Parsing(symbolMap, false);
    }

    UCUMFormat(SymbolMapImpl symbolMap) {
        this._symbolMap = symbolMap;
    }

    @Override
    public SymbolMapImpl getSymbolMap() {
        return this._symbolMap;
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        CharSequence symbol;
        String mapSymbol;
        String annotation = null;
        if (unit instanceof AnnotatedUnit) {
            AnnotatedUnit annotatedUnit = (AnnotatedUnit)unit;
            unit = annotatedUnit.getRealUnit();
            annotation = annotatedUnit.getAnnotation();
        }
        if ((mapSymbol = this._symbolMap.getSymbol(unit)) != null) {
            symbol = mapSymbol;
        } else if (unit instanceof ProductUnit) {
            ProductUnit productUnit = (ProductUnit)unit;
            StringBuffer app = new StringBuffer();
            for (int i = 0; i < productUnit.getUnitCount(); ++i) {
                if (productUnit.getUnitRoot(i) != 1) {
                    throw new IllegalArgumentException("Unable to format units in UCUM (fractional powers not supported)");
                }
                StringBuffer temp = new StringBuffer();
                temp = (StringBuffer)this.format(productUnit.getUnit(i), temp);
                if (temp.indexOf(".") >= 0 || temp.indexOf("/") >= 0) {
                    temp.insert(0, '(');
                    temp.append(')');
                }
                int pow = productUnit.getUnitPow(i);
                if (i > 0) {
                    if (pow >= 0) {
                        app.append('.');
                    } else if (i < productUnit.getUnitCount() - 1) {
                        app.append('.');
                    } else {
                        app.append('/');
                        pow = -pow;
                    }
                } else if (pow < 0) {
                    app.append('/');
                    pow = -pow;
                }
                app.append(temp);
                if (pow == 1) continue;
                app.append(Integer.toString(pow));
            }
            symbol = app;
        } else if (unit instanceof TransformedUnit || unit.equals(SI.KILOGRAM)) {
            boolean printSeparator;
            UnitConverter converter;
            StringBuffer temp = new StringBuffer();
            if (unit.equals(SI.KILOGRAM)) {
                temp = this.format(UCUM.GRAM, temp, new FieldPosition(0));
                converter = Prefix.KILO.getConverter();
                printSeparator = true;
            } else {
                TransformedUnit transformedUnit = (TransformedUnit)unit;
                Unit<Object> parentUnits = transformedUnit.getParentUnit();
                converter = transformedUnit.toParentUnit();
                if (parentUnits.equals(SI.KILOGRAM)) {
                    parentUnits = UCUM.GRAM;
                    converter = converter.concatenate(Prefix.KILO.getConverter());
                }
                temp = this.format(parentUnits, temp, new FieldPosition(0));
                printSeparator = !parentUnits.equals(Unit.ONE);
            }
            this.formatConverter(converter, printSeparator, temp);
            symbol = temp;
        } else if (unit instanceof BaseUnit) {
            symbol = ((BaseUnit)unit).getSymbol();
        } else if (unit instanceof AlternateUnit) {
            symbol = ((AlternateUnit)unit).getSymbol();
        } else {
            throw new IllegalArgumentException("Symbol mapping for unit of type " + unit.getClass().getName() + " has not been set " + "(see UnitFormat.SymbolMap)");
        }
        appendable.append(symbol);
        if (annotation != null && annotation.length() > 0) {
            this.appendAnnotation(unit, symbol, annotation, appendable);
        }
        return appendable;
    }

    void appendAnnotation(Unit<?> unit, CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
        appendable.append('{');
        appendable.append(annotation);
        appendable.append('}');
    }

    void formatConverter(UnitConverter converter, boolean continued, StringBuffer buffer) {
        boolean unitIsExpression = buffer.indexOf(".") >= 0 || buffer.indexOf("/") >= 0;
        Prefix prefix = this._symbolMap.getPrefixObject(converter);
        if (prefix != null && !unitIsExpression) {
            buffer.insert(0, this._symbolMap.getSymbol(prefix));
        } else if (converter != UnitConverter.IDENTITY) {
            if (converter instanceof MultiplyConverter) {
                MultiplyConverter multiplyConverter;
                double factor;
                long lFactor;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if ((double)(lFactor = (long)(factor = (multiplyConverter = (MultiplyConverter)converter).getFactor())) != factor || lFactor < -9007199254740992L || lFactor > 0x20000000000000L) {
                    throw new IllegalArgumentException("Only integer factors are supported in UCUM");
                }
                if (continued) {
                    buffer.append('.');
                }
                buffer.append(lFactor);
            } else if (converter instanceof RationalConverter) {
                RationalConverter rationalConverter;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if (!(rationalConverter = (RationalConverter)converter).getDividend().equals(BigInteger.ONE)) {
                    if (continued) {
                        buffer.append('.');
                    }
                    buffer.append(rationalConverter.getDividend());
                }
                if (!rationalConverter.getDivisor().equals(BigInteger.ONE)) {
                    buffer.append('/');
                    buffer.append(rationalConverter.getDivisor());
                }
            } else {
                throw new IllegalArgumentException("Unable to format units in UCUM (unsupported UnitConverter " + converter + ")");
            }
        }
    }

    static /* synthetic */ String access$300() {
        return BUNDLE_BASE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parsing
    extends UCUMFormat {
        private static final long serialVersionUID = -922531801940132715L;
        private static final SymbolMapImpl CASE_SENSITIVE_SYMBOLS = new SymbolMapImpl(ResourceBundle.getBundle(UCUMFormat.access$300() + "_CS"));
        private static final SymbolMapImpl CASE_INSENSITIVE_SYMBOLS = new SymbolMapImpl(ResourceBundle.getBundle(UCUMFormat.access$300() + "_CI"));
        private static final Parsing DEFAULT_CS = new Parsing(CASE_SENSITIVE_SYMBOLS, true);
        private static final Parsing DEFAULT_CI = new Parsing(CASE_INSENSITIVE_SYMBOLS, false);
        private final boolean _caseSensitive;

        public Parsing(SymbolMapImpl symbols, boolean caseSensitive) {
            super(symbols);
            this._caseSensitive = caseSensitive;
        }

        public Unit<? extends Quantity> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            int start = cursor.getIndex();
            int end = csq.length();
            if (end <= start) {
                return Unit.ONE;
            }
            String source = ((Object)csq.subSequence(start, end)).toString().trim();
            if (source.length() == 0) {
                return Unit.ONE;
            }
            if (!this._caseSensitive) {
                source = source.toUpperCase();
            }
            UCUMParser parser = new UCUMParser(this._symbolMap, new ByteArrayInputStream(source.getBytes()));
            try {
                Unit result = parser.parseUnit();
                cursor.setIndex(end);
                return result;
            }
            catch (ParseException e) {
                if (e.currentToken != null) {
                    cursor.setErrorIndex(start + e.currentToken.endColumn);
                } else {
                    cursor.setErrorIndex(start);
                }
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (TokenMgrError e) {
                cursor.setErrorIndex(start);
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Print
    extends UCUMFormat {
        private static final long serialVersionUID = 2990875526976721414L;
        private static final SymbolMapImpl PRINT_SYMBOLS = new SymbolMapImpl(ResourceBundle.getBundle(UCUMFormat.access$300() + "_Print"));
        private static final Print DEFAULT = new Print(PRINT_SYMBOLS);

        public Print(SymbolMapImpl symbols) {
            super(symbols);
        }

        public Unit<? extends Quantity> parse(CharSequence csq, ParsePosition pos) throws IllegalArgumentException {
            throw new UnsupportedOperationException("The print format is for pretty-printing of units only. Parsing is not supported.");
        }

        @Override
        void appendAnnotation(Unit<?> unit, CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
            if (symbol != null && symbol.length() > 0) {
                appendable.append('(');
                appendable.append(annotation);
                appendable.append(')');
            } else {
                appendable.append(annotation);
            }
        }
    }
}

