/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Dimension;
import javax.measure.unit.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProductUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private static final long serialVersionUID = 1649531873171667706L;
    private final Element[] _elements;
    private int _hashCode;

    ProductUnit() {
        this._elements = new Element[0];
    }

    public ProductUnit(Unit<?> productUnit) {
        this._elements = ((ProductUnit)productUnit)._elements;
    }

    private ProductUnit(Element[] elements) {
        this._elements = elements;
    }

    private static Unit<? extends Quantity> getInstance(Element[] leftElems, Element[] rightElems) {
        Unit unit;
        int i;
        Element[] result = new Element[leftElems.length + rightElems.length];
        int resultIndex = 0;
        for (i = 0; i < leftElems.length; ++i) {
            unit = leftElems[i]._unit;
            int p1 = leftElems[i]._pow;
            int r1 = leftElems[i]._root;
            int p2 = 0;
            int r2 = 1;
            for (int j = 0; j < rightElems.length; ++j) {
                if (!unit.equals(rightElems[j]._unit)) continue;
                p2 = rightElems[j]._pow;
                r2 = rightElems[j]._root;
                break;
            }
            int pow = p1 * r2 + p2 * r1;
            int root = r1 * r2;
            if (pow == 0) continue;
            int gcd = ProductUnit.gcd(Math.abs(pow), root);
            result[resultIndex++] = new Element(unit, pow / gcd, root / gcd);
        }
        for (i = 0; i < rightElems.length; ++i) {
            unit = rightElems[i]._unit;
            boolean hasBeenMerged = false;
            for (int j = 0; j < leftElems.length; ++j) {
                if (!unit.equals(leftElems[j]._unit)) continue;
                hasBeenMerged = true;
                break;
            }
            if (hasBeenMerged) continue;
            result[resultIndex++] = rightElems[i];
        }
        if (resultIndex == 0) {
            return ONE;
        }
        if (resultIndex == 1 && result[0]._pow == result[0]._root) {
            return result[0]._unit;
        }
        Element[] elems = new Element[resultIndex];
        for (int i2 = 0; i2 < resultIndex; ++i2) {
            elems[i2] = result[i2];
        }
        return new ProductUnit(elems);
    }

    static Unit<? extends Quantity> getProductInstance(Unit<?> left, Unit<?> right) {
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left)._elements : new Element[]{new Element(left, 1, 1)};
        Element[] rightElems = right instanceof ProductUnit ? ((ProductUnit)right)._elements : new Element[]{new Element(right, 1, 1)};
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    static Unit<? extends Quantity> getQuotientInstance(Unit<?> left, Unit<?> right) {
        Element[] rightElems;
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left)._elements : new Element[]{new Element(left, 1, 1)};
        if (right instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)right)._elements;
            rightElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                rightElems[i] = new Element(elems[i]._unit, -elems[i]._pow, elems[i]._root);
            }
        } else {
            rightElems = new Element[]{new Element(right, -1, 1)};
        }
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    static Unit<? extends Quantity> getRootInstance(Unit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit)._elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i]._pow), elems[i]._root * n);
                unitElems[i] = new Element(elems[i]._unit, elems[i]._pow / gcd, elems[i]._root * n / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    static Unit<? extends Quantity> getPowInstance(Unit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit)._elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i]._pow * n), elems[i]._root);
                unitElems[i] = new Element(elems[i]._unit, elems[i]._pow * n / gcd, elems[i]._root / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, n, 1)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public int getUnitCount() {
        return this._elements.length;
    }

    public Unit<? extends Quantity> getUnit(int index) {
        return this._elements[index].getUnit();
    }

    public int getUnitPow(int index) {
        return this._elements[index].getPow();
    }

    public int getUnitRoot(int index) {
        return this._elements[index].getRoot();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof ProductUnit)) {
            return false;
        }
        Element[] elems = ((ProductUnit)that)._elements;
        if (this._elements.length != elems.length) {
            return false;
        }
        for (int i = 0; i < this._elements.length; ++i) {
            boolean unitFound = false;
            Element e = this._elements[i];
            for (int j = 0; j < elems.length; ++j) {
                if (!e._unit.equals(elems[j]._unit)) continue;
                if (e._pow != elems[j]._pow || e._root != elems[j]._root) {
                    return false;
                }
                unitFound = true;
                break;
            }
            if (unitFound) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        int code = 0;
        for (int i = 0; i < this._elements.length; ++i) {
            code += this._elements[i]._unit.hashCode() * (this._elements[i]._pow * 3 - this._elements[i]._root * 2);
        }
        this._hashCode = code;
        return code;
    }

    @Override
    public Unit<Q> toSI() {
        if (this.hasOnlyStandardUnit()) {
            return this;
        }
        Unit systemUnit = ONE;
        for (int i = 0; i < this._elements.length; ++i) {
            Unit<Object> unit = this._elements[i]._unit.toSI();
            unit = unit.pow(this._elements[i]._pow);
            unit = unit.root(this._elements[i]._root);
            systemUnit = systemUnit.times(unit);
        }
        return systemUnit;
    }

    @Override
    public final UnitConverter getConverterToSI() {
        if (this.hasOnlyStandardUnit()) {
            return UnitConverter.IDENTITY;
        }
        UnitConverter converter = UnitConverter.IDENTITY;
        for (int i = 0; i < this._elements.length; ++i) {
            Element e = this._elements[i];
            UnitConverter cvtr = e._unit.getConverterToSI();
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(e._unit + " is non-linear, cannot convert");
            }
            if (e._root != 1) {
                throw new UnsupportedOperationException(e._unit + " holds a base unit with fractional exponent");
            }
            int pow = e._pow;
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                converter = converter.concatenate(cvtr);
            }
        }
        return converter;
    }

    private boolean hasOnlyStandardUnit() {
        for (int i = 0; i < this._elements.length; ++i) {
            Unit u = this._elements[i]._unit;
            if (u.isSI()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Dimension getDimension() {
        Dimension dimension = Dimension.NONE;
        for (int i = 0; i < this.getUnitCount(); ++i) {
            Unit<Quantity> unit = this.getUnit(i);
            Dimension d = unit.getDimension().pow(this.getUnitPow(i)).root(this.getUnitRoot(i));
            dimension = dimension.times(d);
        }
        return dimension;
    }

    @Override
    public UnitConverter getDimensionalTransform() {
        UnitConverter converter = UnitConverter.IDENTITY;
        for (int i = 0; i < this.getUnitCount(); ++i) {
            Unit<Quantity> unit = this.getUnit(i);
            UnitConverter cvtr = unit.getDimensionalTransform();
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(cvtr.getClass() + " is non-linear, cannot convert product unit");
            }
            if (this.getUnitRoot(i) != 1) {
                throw new UnsupportedOperationException(this + " holds a unit with fractional exponent");
            }
            int pow = this.getUnitPow(i);
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                converter = converter.concatenate(cvtr);
            }
        }
        return converter;
    }

    private static int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return ProductUnit.gcd(n, m % n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Element
    implements Serializable {
        private final Unit<?> _unit;
        private final int _pow;
        private final int _root;
        private static final long serialVersionUID = 1L;

        private Element(Unit<?> unit, int pow, int root) {
            this._unit = unit;
            this._pow = pow;
            this._root = root;
        }

        public Unit<?> getUnit() {
            return this._unit;
        }

        public int getPow() {
            return this._pow;
        }

        public int getRoot() {
            return this._root;
        }
    }
}

