/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;

public abstract class UnitConverter
implements Serializable {
    private static final long serialVersionUID = 2557410026012911803L;
    public static final UnitConverter IDENTITY = new Identity();

    protected UnitConverter() {
    }

    public abstract UnitConverter inverse();

    public abstract double convert(double var1);

    public abstract BigDecimal convert(BigDecimal var1, MathContext var2) throws ArithmeticException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public UnitConverter concatenate(UnitConverter converter) {
        return converter == IDENTITY ? this : new CompoundImpl(this, converter);
    }

    public abstract boolean isLinear();

    private static final class CompoundImpl
    extends UnitConverter
    implements Compound {
        private static final long serialVersionUID = 2242882007946934958L;
        private final UnitConverter left;
        private final UnitConverter right;

        private CompoundImpl(UnitConverter left, UnitConverter right) {
            this.left = left;
            this.right = right;
        }

        public UnitConverter inverse() {
            return new CompoundImpl(this.right.inverse(), this.left.inverse());
        }

        public double convert(double value) {
            return this.left.convert(this.right.convert(value));
        }

        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return this.left.convert(this.right.convert(value, ctx), ctx);
        }

        public boolean equals(Object cvtr) {
            if (this == cvtr) {
                return true;
            }
            if (!(cvtr instanceof Compound)) {
                return false;
            }
            Compound that = (Compound)cvtr;
            return this.left.equals(that.getLeft()) && this.right.equals(that.getRight());
        }

        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        public boolean isLinear() {
            return this.left.isLinear() && this.right.isLinear();
        }

        public UnitConverter getLeft() {
            return this.left;
        }

        public UnitConverter getRight() {
            return this.right;
        }
    }

    private static final class Identity
    extends UnitConverter {
        private static final long serialVersionUID = 7675901502919547460L;

        private Identity() {
        }

        public Identity inverse() {
            return this;
        }

        public double convert(double value) {
            return value;
        }

        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return value;
        }

        public UnitConverter concatenate(UnitConverter converter) {
            return converter;
        }

        public boolean equals(Object cvtr) {
            return this == cvtr;
        }

        public int hashCode() {
            return 0;
        }

        public boolean isLinear() {
            return true;
        }
    }

    public static interface Compound {
        public UnitConverter getLeft();

        public UnitConverter getRight();
    }
}

