/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.converter.LogConverter;
import javax.measure.converter.UnitConverter;

public final class ExpConverter
extends UnitConverter {
    private static final long serialVersionUID = -1862583888012861945L;
    private final double base;
    private final double logOfBase;

    public ExpConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    public UnitConverter inverse() {
        return new LogConverter(this.base);
    }

    public final String toString() {
        return "ExpConverter(" + this.base + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpConverter)) {
            return false;
        }
        ExpConverter that = (ExpConverter)obj;
        return this.base == that.base;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.base);
        return (int)(bits ^ bits >>> 32);
    }

    public double convert(double amount) {
        return Math.exp(this.logOfBase * amount);
    }

    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    public boolean isLinear() {
        return false;
    }
}

