/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff.gdal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="GDALMetadata")
public class GDALMetadata {
    @XmlElement(name="Item", required=true)
    protected List<Item> items;

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public String toString() {
        return "GDALMetadata{items=" + this.items + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GDALMetadata that = (GDALMetadata)o;
        return Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.items);
    }

    public Double[] getOffsets(int bands) {
        return this.getBandDoubleValues(bands, "offset");
    }

    public Double[] getScales(int bands) {
        return this.getBandDoubleValues(bands, "scale");
    }

    private Double[] getBandDoubleValues(int bands, String role) {
        if (this.items == null) {
            return null;
        }
        Map<Integer, Double> bandsToValues = this.items.stream().filter(i -> Objects.equals(role, i.getRole()) && i.getSample() != null && i.getSample() < bands).collect(Collectors.toMap(i -> i.getSample(), i -> Double.parseDouble(i.getValue())));
        if (bandsToValues.isEmpty()) {
            return null;
        }
        Double[] values = new Double[bands];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = bandsToValues.get(i2);
        }
        return values;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Item {
        @XmlValue
        String value;
        @XmlAttribute
        String name;
        @XmlAttribute
        Integer sample;
        @XmlAttribute
        String role;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getSample() {
            return this.sample;
        }

        public void setSample(Integer sample) {
            this.sample = sample;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equals(this.value, item.value) && Objects.equals(this.name, item.name) && Objects.equals(this.sample, item.sample) && Objects.equals(this.role, item.role);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.name, this.sample, this.role);
        }

        public String toString() {
            return "Item{value='" + this.value + "', name='" + this.name + "', sample=" + this.sample + ", role='" + this.role + "'}";
        }
    }
}

