/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ReferenceCountUtil;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLCodec;
import java.util.ArrayDeque;
import java.util.List;

class MySQLDecoder
extends ByteToMessageDecoder {
    private final ArrayDeque<CommandCodec<?, ?>> inflight;
    private final MySQLSocketConnection socketConnection;
    private CompositeByteBuf aggregatedPacketPayload = null;

    MySQLDecoder(ArrayDeque<CommandCodec<?, ?>> inflight, MySQLSocketConnection socketConnection) {
        this.inflight = inflight;
        this.socketConnection = socketConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() > 4) {
            int packetStartIdx = in.readerIndex();
            int payloadLength = in.readUnsignedMediumLE();
            short sequenceId = in.readUnsignedByte();
            if (payloadLength >= 0xFFFFFF && this.aggregatedPacketPayload == null) {
                this.aggregatedPacketPayload = ctx.alloc().compositeBuffer();
            }
            if (in.readableBytes() >= payloadLength) {
                if (this.aggregatedPacketPayload != null) {
                    this.aggregatedPacketPayload.addComponent(true, in.readRetainedSlice(payloadLength));
                    if (payloadLength < 0xFFFFFF) {
                        try {
                            this.decodePacket((ByteBuf)this.aggregatedPacketPayload, this.aggregatedPacketPayload.readableBytes(), sequenceId);
                        }
                        finally {
                            ReferenceCountUtil.release((Object)this.aggregatedPacketPayload);
                            this.aggregatedPacketPayload = null;
                        }
                    }
                } else {
                    this.decodePacket(in.readSlice(payloadLength), payloadLength, sequenceId);
                }
            } else {
                in.readerIndex(packetStartIdx);
            }
        }
    }

    private void decodePacket(ByteBuf payload, int payloadLength, int sequenceId) {
        MySQLCodec.checkFireAndForgetCommands(this.inflight);
        CommandCodec<?, ?> ctx = this.inflight.peek();
        ctx.sequenceId = sequenceId + 1;
        ctx.decodePayload(payload, payloadLength);
        MySQLCodec.checkFireAndForgetCommands(this.inflight);
    }
}

