/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.mysqlclient.MySQLBatchException;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.mysqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.mysqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.List;

class ExtendedBatchQueryCommandCodec<R>
extends ExtendedQueryCommandBaseCodec<R, ExtendedQueryCommand<R>> {
    private final List<Tuple> params;
    private int batchIdx = 0;

    ExtendedBatchQueryCommandCodec(ExtendedQueryCommand<R> cmd) {
        super(cmd);
        this.params = cmd.paramsList();
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        if (this.params.isEmpty() && this.statement.paramDesc.paramDefinitions().length > 0) {
            encoder.handleCommandResponse(CommandResponse.failure((String)"Statement parameter is not set because of the empty batch param list"));
            return;
        }
        encoder.socketConnection.suspendPipeline();
        this.doExecuteBatch();
        MySQLPreparedStatement ps = (MySQLPreparedStatement)((ExtendedQueryCommand)this.cmd).ps;
        if (ps.closeAfterUsage) {
            this.sendCloseStatementCommand(ps);
        }
    }

    @Override
    void handleErrorPacketPayload(ByteBuf payload) {
        MySQLException mySQLException = this.decodeErrorPacketPayload(payload);
        this.reportError(this.batchIdx, mySQLException);
        this.commandHandlerState = QueryCommandBaseCodec.CommandHandlerState.INIT;
        ++this.batchIdx;
    }

    @Override
    protected void handleSingleResultsetDecodingCompleted(int serverStatusFlags, long affectedRows, long lastInsertId) {
        ++this.batchIdx;
        super.handleSingleResultsetDecodingCompleted(serverStatusFlags, affectedRows, lastInsertId);
    }

    @Override
    protected boolean isDecodingCompleted(int serverStatusFlags) {
        return super.isDecodingCompleted(serverStatusFlags) && this.batchIdx == this.params.size();
    }

    @Override
    protected void handleAllResultsetDecodingCompleted() {
        this.encoder.socketConnection.resumePipeline();
        super.handleAllResultsetDecodingCompleted();
    }

    private void doExecuteBatch() {
        for (int i = 0; i < this.params.size(); ++i) {
            Tuple param = this.params.get(i);
            this.sequenceId = 0;
            String bindMsg = this.statement.bindParameters(param);
            if (bindMsg != null) {
                this.reportError(i, (Throwable)new NoStackTraceThrowable(bindMsg));
                continue;
            }
            this.sendStatementExecuteCommand(this.statement, this.statement.sendTypesToServer(), param, (byte)0);
        }
    }

    private void reportError(int iteration, Throwable error) {
        if (this.failure == null) {
            this.failure = new MySQLBatchException();
        }
        ((MySQLBatchException)this.failure).reportError(iteration, error);
    }
}

